package zio.aws.s3.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.s3.model.primitives.{
  SSECustomerKey,
  CopySourceSSECustomerKeyMD5,
  CopySourceSSECustomerAlgorithm,
  ContentType,
  CacheControl,
  WebsiteRedirectLocation,
  GrantRead,
  ContentDisposition,
  ContentLanguage,
  GrantReadACP,
  AccountId,
  SSECustomerAlgorithm,
  CopySourceIfUnmodifiedSince,
  SSECustomerKeyMD5,
  SSEKMSEncryptionContext,
  CopySourceIfMatch,
  Expires,
  ContentEncoding,
  ObjectKey,
  GrantWriteACP,
  GrantFullControl,
  BucketName,
  SSEKMSKeyId,
  CopySourceSSECustomerKey,
  MetadataValue,
  TaggingHeader,
  CopySourceIfNoneMatch,
  ObjectLockRetainUntilDate,
  CopySourceIfModifiedSince,
  MetadataKey,
  CopySource,
  BucketKeyEnabled
}
import scala.jdk.CollectionConverters.*
final case class CopyObjectRequest(
    acl: Optional[zio.aws.s3.model.ObjectCannedACL] = Optional.Absent,
    destinationBucket: BucketName,
    cacheControl: Optional[CacheControl] = Optional.Absent,
    checksumAlgorithm: Optional[zio.aws.s3.model.ChecksumAlgorithm] =
      Optional.Absent,
    contentDisposition: Optional[ContentDisposition] = Optional.Absent,
    contentEncoding: Optional[ContentEncoding] = Optional.Absent,
    contentLanguage: Optional[ContentLanguage] = Optional.Absent,
    contentType: Optional[ContentType] = Optional.Absent,
    copySource: CopySource,
    copySourceIfMatch: Optional[CopySourceIfMatch] = Optional.Absent,
    copySourceIfModifiedSince: Optional[CopySourceIfModifiedSince] =
      Optional.Absent,
    copySourceIfNoneMatch: Optional[CopySourceIfNoneMatch] = Optional.Absent,
    copySourceIfUnmodifiedSince: Optional[CopySourceIfUnmodifiedSince] =
      Optional.Absent,
    expires: Optional[Expires] = Optional.Absent,
    grantFullControl: Optional[GrantFullControl] = Optional.Absent,
    grantRead: Optional[GrantRead] = Optional.Absent,
    grantReadACP: Optional[GrantReadACP] = Optional.Absent,
    grantWriteACP: Optional[GrantWriteACP] = Optional.Absent,
    destinationKey: ObjectKey,
    metadata: Optional[Map[MetadataKey, MetadataValue]] = Optional.Absent,
    metadataDirective: Optional[zio.aws.s3.model.MetadataDirective] =
      Optional.Absent,
    taggingDirective: Optional[zio.aws.s3.model.TaggingDirective] =
      Optional.Absent,
    serverSideEncryption: Optional[zio.aws.s3.model.ServerSideEncryption] =
      Optional.Absent,
    storageClass: Optional[zio.aws.s3.model.StorageClass] = Optional.Absent,
    websiteRedirectLocation: Optional[WebsiteRedirectLocation] =
      Optional.Absent,
    sseCustomerAlgorithm: Optional[SSECustomerAlgorithm] = Optional.Absent,
    sseCustomerKey: Optional[SSECustomerKey] = Optional.Absent,
    sseCustomerKeyMD5: Optional[SSECustomerKeyMD5] = Optional.Absent,
    ssekmsKeyId: Optional[SSEKMSKeyId] = Optional.Absent,
    ssekmsEncryptionContext: Optional[SSEKMSEncryptionContext] =
      Optional.Absent,
    bucketKeyEnabled: Optional[BucketKeyEnabled] = Optional.Absent,
    copySourceSSECustomerAlgorithm: Optional[CopySourceSSECustomerAlgorithm] =
      Optional.Absent,
    copySourceSSECustomerKey: Optional[CopySourceSSECustomerKey] =
      Optional.Absent,
    copySourceSSECustomerKeyMD5: Optional[CopySourceSSECustomerKeyMD5] =
      Optional.Absent,
    requestPayer: Optional[zio.aws.s3.model.RequestPayer] = Optional.Absent,
    tagging: Optional[TaggingHeader] = Optional.Absent,
    objectLockMode: Optional[zio.aws.s3.model.ObjectLockMode] = Optional.Absent,
    objectLockRetainUntilDate: Optional[ObjectLockRetainUntilDate] =
      Optional.Absent,
    objectLockLegalHoldStatus: Optional[
      zio.aws.s3.model.ObjectLockLegalHoldStatus
    ] = Optional.Absent,
    expectedBucketOwner: Optional[AccountId] = Optional.Absent,
    expectedSourceBucketOwner: Optional[AccountId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.CopyObjectRequest = {
    import CopyObjectRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.CopyObjectRequest
      .builder()
      .optionallyWith(acl.map(value => value.unwrap))(_.acl)
      .destinationBucket(BucketName.unwrap(destinationBucket): java.lang.String)
      .optionallyWith(
        cacheControl.map(value => CacheControl.unwrap(value): java.lang.String)
      )(_.cacheControl)
      .optionallyWith(checksumAlgorithm.map(value => value.unwrap))(
        _.checksumAlgorithm
      )
      .optionallyWith(
        contentDisposition.map(value =>
          ContentDisposition.unwrap(value): java.lang.String
        )
      )(_.contentDisposition)
      .optionallyWith(
        contentEncoding.map(value =>
          ContentEncoding.unwrap(value): java.lang.String
        )
      )(_.contentEncoding)
      .optionallyWith(
        contentLanguage.map(value =>
          ContentLanguage.unwrap(value): java.lang.String
        )
      )(_.contentLanguage)
      .optionallyWith(
        contentType.map(value => ContentType.unwrap(value): java.lang.String)
      )(_.contentType)
      .copySource(CopySource.unwrap(copySource): java.lang.String)
      .optionallyWith(
        copySourceIfMatch.map(value =>
          CopySourceIfMatch.unwrap(value): java.lang.String
        )
      )(_.copySourceIfMatch)
      .optionallyWith(
        copySourceIfModifiedSince.map(value =>
          CopySourceIfModifiedSince.unwrap(value): Instant
        )
      )(_.copySourceIfModifiedSince)
      .optionallyWith(
        copySourceIfNoneMatch.map(value =>
          CopySourceIfNoneMatch.unwrap(value): java.lang.String
        )
      )(_.copySourceIfNoneMatch)
      .optionallyWith(
        copySourceIfUnmodifiedSince.map(value =>
          CopySourceIfUnmodifiedSince.unwrap(value): Instant
        )
      )(_.copySourceIfUnmodifiedSince)
      .optionallyWith(expires.map(value => Expires.unwrap(value): Instant))(
        _.expires
      )
      .optionallyWith(
        grantFullControl.map(value =>
          GrantFullControl.unwrap(value): java.lang.String
        )
      )(_.grantFullControl)
      .optionallyWith(
        grantRead.map(value => GrantRead.unwrap(value): java.lang.String)
      )(_.grantRead)
      .optionallyWith(
        grantReadACP.map(value => GrantReadACP.unwrap(value): java.lang.String)
      )(_.grantReadACP)
      .optionallyWith(
        grantWriteACP.map(value =>
          GrantWriteACP.unwrap(value): java.lang.String
        )
      )(_.grantWriteACP)
      .destinationKey(ObjectKey.unwrap(destinationKey): java.lang.String)
      .optionallyWith(
        metadata.map(value =>
          value
            .map({ case (key, value) =>
              (MetadataKey.unwrap(key): java.lang.String) -> (MetadataValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.metadata)
      .optionallyWith(metadataDirective.map(value => value.unwrap))(
        _.metadataDirective
      )
      .optionallyWith(taggingDirective.map(value => value.unwrap))(
        _.taggingDirective
      )
      .optionallyWith(serverSideEncryption.map(value => value.unwrap))(
        _.serverSideEncryption
      )
      .optionallyWith(storageClass.map(value => value.unwrap))(_.storageClass)
      .optionallyWith(
        websiteRedirectLocation.map(value =>
          WebsiteRedirectLocation.unwrap(value): java.lang.String
        )
      )(_.websiteRedirectLocation)
      .optionallyWith(
        sseCustomerAlgorithm.map(value =>
          SSECustomerAlgorithm.unwrap(value): java.lang.String
        )
      )(_.sseCustomerAlgorithm)
      .optionallyWith(
        sseCustomerKey.map(value =>
          SSECustomerKey.unwrap(value): java.lang.String
        )
      )(_.sseCustomerKey)
      .optionallyWith(
        sseCustomerKeyMD5.map(value =>
          SSECustomerKeyMD5.unwrap(value): java.lang.String
        )
      )(_.sseCustomerKeyMD5)
      .optionallyWith(
        ssekmsKeyId.map(value => SSEKMSKeyId.unwrap(value): java.lang.String)
      )(_.ssekmsKeyId)
      .optionallyWith(
        ssekmsEncryptionContext.map(value =>
          SSEKMSEncryptionContext.unwrap(value): java.lang.String
        )
      )(_.ssekmsEncryptionContext)
      .optionallyWith(
        bucketKeyEnabled.map(value =>
          BucketKeyEnabled.unwrap(value): java.lang.Boolean
        )
      )(_.bucketKeyEnabled)
      .optionallyWith(
        copySourceSSECustomerAlgorithm.map(value =>
          CopySourceSSECustomerAlgorithm.unwrap(value): java.lang.String
        )
      )(_.copySourceSSECustomerAlgorithm)
      .optionallyWith(
        copySourceSSECustomerKey.map(value =>
          CopySourceSSECustomerKey.unwrap(value): java.lang.String
        )
      )(_.copySourceSSECustomerKey)
      .optionallyWith(
        copySourceSSECustomerKeyMD5.map(value =>
          CopySourceSSECustomerKeyMD5.unwrap(value): java.lang.String
        )
      )(_.copySourceSSECustomerKeyMD5)
      .optionallyWith(requestPayer.map(value => value.unwrap))(_.requestPayer)
      .optionallyWith(
        tagging.map(value => TaggingHeader.unwrap(value): java.lang.String)
      )(_.tagging)
      .optionallyWith(objectLockMode.map(value => value.unwrap))(
        _.objectLockMode
      )
      .optionallyWith(
        objectLockRetainUntilDate.map(value =>
          ObjectLockRetainUntilDate.unwrap(value): Instant
        )
      )(_.objectLockRetainUntilDate)
      .optionallyWith(objectLockLegalHoldStatus.map(value => value.unwrap))(
        _.objectLockLegalHoldStatus
      )
      .optionallyWith(
        expectedBucketOwner.map(value =>
          AccountId.unwrap(value): java.lang.String
        )
      )(_.expectedBucketOwner)
      .optionallyWith(
        expectedSourceBucketOwner.map(value =>
          AccountId.unwrap(value): java.lang.String
        )
      )(_.expectedSourceBucketOwner)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.CopyObjectRequest.ReadOnly =
    zio.aws.s3.model.CopyObjectRequest.wrap(buildAwsValue())
}
object CopyObjectRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.CopyObjectRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.CopyObjectRequest =
      zio.aws.s3.model.CopyObjectRequest(
        acl.map(value => value),
        destinationBucket,
        cacheControl.map(value => value),
        checksumAlgorithm.map(value => value),
        contentDisposition.map(value => value),
        contentEncoding.map(value => value),
        contentLanguage.map(value => value),
        contentType.map(value => value),
        copySource,
        copySourceIfMatch.map(value => value),
        copySourceIfModifiedSince.map(value => value),
        copySourceIfNoneMatch.map(value => value),
        copySourceIfUnmodifiedSince.map(value => value),
        expires.map(value => value),
        grantFullControl.map(value => value),
        grantRead.map(value => value),
        grantReadACP.map(value => value),
        grantWriteACP.map(value => value),
        destinationKey,
        metadata.map(value => value),
        metadataDirective.map(value => value),
        taggingDirective.map(value => value),
        serverSideEncryption.map(value => value),
        storageClass.map(value => value),
        websiteRedirectLocation.map(value => value),
        sseCustomerAlgorithm.map(value => value),
        sseCustomerKey.map(value => value),
        sseCustomerKeyMD5.map(value => value),
        ssekmsKeyId.map(value => value),
        ssekmsEncryptionContext.map(value => value),
        bucketKeyEnabled.map(value => value),
        copySourceSSECustomerAlgorithm.map(value => value),
        copySourceSSECustomerKey.map(value => value),
        copySourceSSECustomerKeyMD5.map(value => value),
        requestPayer.map(value => value),
        tagging.map(value => value),
        objectLockMode.map(value => value),
        objectLockRetainUntilDate.map(value => value),
        objectLockLegalHoldStatus.map(value => value),
        expectedBucketOwner.map(value => value),
        expectedSourceBucketOwner.map(value => value)
      )
    def acl: Optional[zio.aws.s3.model.ObjectCannedACL]
    def destinationBucket: BucketName
    def cacheControl: Optional[CacheControl]
    def checksumAlgorithm: Optional[zio.aws.s3.model.ChecksumAlgorithm]
    def contentDisposition: Optional[ContentDisposition]
    def contentEncoding: Optional[ContentEncoding]
    def contentLanguage: Optional[ContentLanguage]
    def contentType: Optional[ContentType]
    def copySource: CopySource
    def copySourceIfMatch: Optional[CopySourceIfMatch]
    def copySourceIfModifiedSince: Optional[CopySourceIfModifiedSince]
    def copySourceIfNoneMatch: Optional[CopySourceIfNoneMatch]
    def copySourceIfUnmodifiedSince: Optional[CopySourceIfUnmodifiedSince]
    def expires: Optional[Expires]
    def grantFullControl: Optional[GrantFullControl]
    def grantRead: Optional[GrantRead]
    def grantReadACP: Optional[GrantReadACP]
    def grantWriteACP: Optional[GrantWriteACP]
    def destinationKey: ObjectKey
    def metadata: Optional[Map[MetadataKey, MetadataValue]]
    def metadataDirective: Optional[zio.aws.s3.model.MetadataDirective]
    def taggingDirective: Optional[zio.aws.s3.model.TaggingDirective]
    def serverSideEncryption: Optional[zio.aws.s3.model.ServerSideEncryption]
    def storageClass: Optional[zio.aws.s3.model.StorageClass]
    def websiteRedirectLocation: Optional[WebsiteRedirectLocation]
    def sseCustomerAlgorithm: Optional[SSECustomerAlgorithm]
    def sseCustomerKey: Optional[SSECustomerKey]
    def sseCustomerKeyMD5: Optional[SSECustomerKeyMD5]
    def ssekmsKeyId: Optional[SSEKMSKeyId]
    def ssekmsEncryptionContext: Optional[SSEKMSEncryptionContext]
    def bucketKeyEnabled: Optional[BucketKeyEnabled]
    def copySourceSSECustomerAlgorithm: Optional[CopySourceSSECustomerAlgorithm]
    def copySourceSSECustomerKey: Optional[CopySourceSSECustomerKey]
    def copySourceSSECustomerKeyMD5: Optional[CopySourceSSECustomerKeyMD5]
    def requestPayer: Optional[zio.aws.s3.model.RequestPayer]
    def tagging: Optional[TaggingHeader]
    def objectLockMode: Optional[zio.aws.s3.model.ObjectLockMode]
    def objectLockRetainUntilDate: Optional[ObjectLockRetainUntilDate]
    def objectLockLegalHoldStatus
        : Optional[zio.aws.s3.model.ObjectLockLegalHoldStatus]
    def expectedBucketOwner: Optional[AccountId]
    def expectedSourceBucketOwner: Optional[AccountId]
    def getAcl: ZIO[Any, AwsError, zio.aws.s3.model.ObjectCannedACL] =
      AwsError.unwrapOptionField("acl", acl)
    def getDestinationBucket: ZIO[Any, Nothing, BucketName] =
      ZIO.succeed(destinationBucket)
    def getCacheControl: ZIO[Any, AwsError, CacheControl] =
      AwsError.unwrapOptionField("cacheControl", cacheControl)
    def getChecksumAlgorithm
        : ZIO[Any, AwsError, zio.aws.s3.model.ChecksumAlgorithm] =
      AwsError.unwrapOptionField("checksumAlgorithm", checksumAlgorithm)
    def getContentDisposition: ZIO[Any, AwsError, ContentDisposition] =
      AwsError.unwrapOptionField("contentDisposition", contentDisposition)
    def getContentEncoding: ZIO[Any, AwsError, ContentEncoding] =
      AwsError.unwrapOptionField("contentEncoding", contentEncoding)
    def getContentLanguage: ZIO[Any, AwsError, ContentLanguage] =
      AwsError.unwrapOptionField("contentLanguage", contentLanguage)
    def getContentType: ZIO[Any, AwsError, ContentType] =
      AwsError.unwrapOptionField("contentType", contentType)
    def getCopySource: ZIO[Any, Nothing, CopySource] = ZIO.succeed(copySource)
    def getCopySourceIfMatch: ZIO[Any, AwsError, CopySourceIfMatch] =
      AwsError.unwrapOptionField("copySourceIfMatch", copySourceIfMatch)
    def getCopySourceIfModifiedSince
        : ZIO[Any, AwsError, CopySourceIfModifiedSince] = AwsError
      .unwrapOptionField("copySourceIfModifiedSince", copySourceIfModifiedSince)
    def getCopySourceIfNoneMatch: ZIO[Any, AwsError, CopySourceIfNoneMatch] =
      AwsError.unwrapOptionField("copySourceIfNoneMatch", copySourceIfNoneMatch)
    def getCopySourceIfUnmodifiedSince
        : ZIO[Any, AwsError, CopySourceIfUnmodifiedSince] =
      AwsError.unwrapOptionField(
        "copySourceIfUnmodifiedSince",
        copySourceIfUnmodifiedSince
      )
    def getExpires: ZIO[Any, AwsError, Expires] =
      AwsError.unwrapOptionField("expires", expires)
    def getGrantFullControl: ZIO[Any, AwsError, GrantFullControl] =
      AwsError.unwrapOptionField("grantFullControl", grantFullControl)
    def getGrantRead: ZIO[Any, AwsError, GrantRead] =
      AwsError.unwrapOptionField("grantRead", grantRead)
    def getGrantReadACP: ZIO[Any, AwsError, GrantReadACP] =
      AwsError.unwrapOptionField("grantReadACP", grantReadACP)
    def getGrantWriteACP: ZIO[Any, AwsError, GrantWriteACP] =
      AwsError.unwrapOptionField("grantWriteACP", grantWriteACP)
    def getDestinationKey: ZIO[Any, Nothing, ObjectKey] =
      ZIO.succeed(destinationKey)
    def getMetadata: ZIO[Any, AwsError, Map[MetadataKey, MetadataValue]] =
      AwsError.unwrapOptionField("metadata", metadata)
    def getMetadataDirective
        : ZIO[Any, AwsError, zio.aws.s3.model.MetadataDirective] =
      AwsError.unwrapOptionField("metadataDirective", metadataDirective)
    def getTaggingDirective
        : ZIO[Any, AwsError, zio.aws.s3.model.TaggingDirective] =
      AwsError.unwrapOptionField("taggingDirective", taggingDirective)
    def getServerSideEncryption
        : ZIO[Any, AwsError, zio.aws.s3.model.ServerSideEncryption] =
      AwsError.unwrapOptionField("serverSideEncryption", serverSideEncryption)
    def getStorageClass: ZIO[Any, AwsError, zio.aws.s3.model.StorageClass] =
      AwsError.unwrapOptionField("storageClass", storageClass)
    def getWebsiteRedirectLocation
        : ZIO[Any, AwsError, WebsiteRedirectLocation] = AwsError
      .unwrapOptionField("websiteRedirectLocation", websiteRedirectLocation)
    def getSseCustomerAlgorithm: ZIO[Any, AwsError, SSECustomerAlgorithm] =
      AwsError.unwrapOptionField("sseCustomerAlgorithm", sseCustomerAlgorithm)
    def getSseCustomerKey: ZIO[Any, AwsError, SSECustomerKey] =
      AwsError.unwrapOptionField("sseCustomerKey", sseCustomerKey)
    def getSseCustomerKeyMD5: ZIO[Any, AwsError, SSECustomerKeyMD5] =
      AwsError.unwrapOptionField("sseCustomerKeyMD5", sseCustomerKeyMD5)
    def getSsekmsKeyId: ZIO[Any, AwsError, SSEKMSKeyId] =
      AwsError.unwrapOptionField("ssekmsKeyId", ssekmsKeyId)
    def getSsekmsEncryptionContext
        : ZIO[Any, AwsError, SSEKMSEncryptionContext] = AwsError
      .unwrapOptionField("ssekmsEncryptionContext", ssekmsEncryptionContext)
    def getBucketKeyEnabled: ZIO[Any, AwsError, BucketKeyEnabled] =
      AwsError.unwrapOptionField("bucketKeyEnabled", bucketKeyEnabled)
    def getCopySourceSSECustomerAlgorithm
        : ZIO[Any, AwsError, CopySourceSSECustomerAlgorithm] =
      AwsError.unwrapOptionField(
        "copySourceSSECustomerAlgorithm",
        copySourceSSECustomerAlgorithm
      )
    def getCopySourceSSECustomerKey
        : ZIO[Any, AwsError, CopySourceSSECustomerKey] = AwsError
      .unwrapOptionField("copySourceSSECustomerKey", copySourceSSECustomerKey)
    def getCopySourceSSECustomerKeyMD5
        : ZIO[Any, AwsError, CopySourceSSECustomerKeyMD5] =
      AwsError.unwrapOptionField(
        "copySourceSSECustomerKeyMD5",
        copySourceSSECustomerKeyMD5
      )
    def getRequestPayer: ZIO[Any, AwsError, zio.aws.s3.model.RequestPayer] =
      AwsError.unwrapOptionField("requestPayer", requestPayer)
    def getTagging: ZIO[Any, AwsError, TaggingHeader] =
      AwsError.unwrapOptionField("tagging", tagging)
    def getObjectLockMode: ZIO[Any, AwsError, zio.aws.s3.model.ObjectLockMode] =
      AwsError.unwrapOptionField("objectLockMode", objectLockMode)
    def getObjectLockRetainUntilDate
        : ZIO[Any, AwsError, ObjectLockRetainUntilDate] = AwsError
      .unwrapOptionField("objectLockRetainUntilDate", objectLockRetainUntilDate)
    def getObjectLockLegalHoldStatus
        : ZIO[Any, AwsError, zio.aws.s3.model.ObjectLockLegalHoldStatus] =
      AwsError.unwrapOptionField(
        "objectLockLegalHoldStatus",
        objectLockLegalHoldStatus
      )
    def getExpectedBucketOwner: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("expectedBucketOwner", expectedBucketOwner)
    def getExpectedSourceBucketOwner: ZIO[Any, AwsError, AccountId] = AwsError
      .unwrapOptionField("expectedSourceBucketOwner", expectedSourceBucketOwner)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.CopyObjectRequest
  ) extends zio.aws.s3.model.CopyObjectRequest.ReadOnly {
    override val acl: Optional[zio.aws.s3.model.ObjectCannedACL] =
      zio.aws.core.internal
        .optionalFromNullable(impl.acl())
        .map(value => zio.aws.s3.model.ObjectCannedACL.wrap(value))
    override val destinationBucket: BucketName =
      zio.aws.s3.model.primitives.BucketName(impl.destinationBucket())
    override val cacheControl: Optional[CacheControl] = zio.aws.core.internal
      .optionalFromNullable(impl.cacheControl())
      .map(value => zio.aws.s3.model.primitives.CacheControl(value))
    override val checksumAlgorithm
        : Optional[zio.aws.s3.model.ChecksumAlgorithm] = zio.aws.core.internal
      .optionalFromNullable(impl.checksumAlgorithm())
      .map(value => zio.aws.s3.model.ChecksumAlgorithm.wrap(value))
    override val contentDisposition: Optional[ContentDisposition] =
      zio.aws.core.internal
        .optionalFromNullable(impl.contentDisposition())
        .map(value => zio.aws.s3.model.primitives.ContentDisposition(value))
    override val contentEncoding: Optional[ContentEncoding] =
      zio.aws.core.internal
        .optionalFromNullable(impl.contentEncoding())
        .map(value => zio.aws.s3.model.primitives.ContentEncoding(value))
    override val contentLanguage: Optional[ContentLanguage] =
      zio.aws.core.internal
        .optionalFromNullable(impl.contentLanguage())
        .map(value => zio.aws.s3.model.primitives.ContentLanguage(value))
    override val contentType: Optional[ContentType] = zio.aws.core.internal
      .optionalFromNullable(impl.contentType())
      .map(value => zio.aws.s3.model.primitives.ContentType(value))
    override val copySource: CopySource =
      zio.aws.s3.model.primitives.CopySource(impl.copySource())
    override val copySourceIfMatch: Optional[CopySourceIfMatch] =
      zio.aws.core.internal
        .optionalFromNullable(impl.copySourceIfMatch())
        .map(value => zio.aws.s3.model.primitives.CopySourceIfMatch(value))
    override val copySourceIfModifiedSince
        : Optional[CopySourceIfModifiedSince] = zio.aws.core.internal
      .optionalFromNullable(impl.copySourceIfModifiedSince())
      .map(value =>
        zio.aws.s3.model.primitives.CopySourceIfModifiedSince(value)
      )
    override val copySourceIfNoneMatch: Optional[CopySourceIfNoneMatch] =
      zio.aws.core.internal
        .optionalFromNullable(impl.copySourceIfNoneMatch())
        .map(value => zio.aws.s3.model.primitives.CopySourceIfNoneMatch(value))
    override val copySourceIfUnmodifiedSince
        : Optional[CopySourceIfUnmodifiedSince] = zio.aws.core.internal
      .optionalFromNullable(impl.copySourceIfUnmodifiedSince())
      .map(value =>
        zio.aws.s3.model.primitives.CopySourceIfUnmodifiedSince(value)
      )
    override val expires: Optional[Expires] = zio.aws.core.internal
      .optionalFromNullable(impl.expires())
      .map(value => zio.aws.s3.model.primitives.Expires(value))
    override val grantFullControl: Optional[GrantFullControl] =
      zio.aws.core.internal
        .optionalFromNullable(impl.grantFullControl())
        .map(value => zio.aws.s3.model.primitives.GrantFullControl(value))
    override val grantRead: Optional[GrantRead] = zio.aws.core.internal
      .optionalFromNullable(impl.grantRead())
      .map(value => zio.aws.s3.model.primitives.GrantRead(value))
    override val grantReadACP: Optional[GrantReadACP] = zio.aws.core.internal
      .optionalFromNullable(impl.grantReadACP())
      .map(value => zio.aws.s3.model.primitives.GrantReadACP(value))
    override val grantWriteACP: Optional[GrantWriteACP] = zio.aws.core.internal
      .optionalFromNullable(impl.grantWriteACP())
      .map(value => zio.aws.s3.model.primitives.GrantWriteACP(value))
    override val destinationKey: ObjectKey =
      zio.aws.s3.model.primitives.ObjectKey(impl.destinationKey())
    override val metadata: Optional[Map[MetadataKey, MetadataValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.metadata())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.s3.model.primitives.MetadataKey(
                key
              ) -> zio.aws.s3.model.primitives.MetadataValue(value)
            })
            .toMap
        )
    override val metadataDirective
        : Optional[zio.aws.s3.model.MetadataDirective] = zio.aws.core.internal
      .optionalFromNullable(impl.metadataDirective())
      .map(value => zio.aws.s3.model.MetadataDirective.wrap(value))
    override val taggingDirective: Optional[zio.aws.s3.model.TaggingDirective] =
      zio.aws.core.internal
        .optionalFromNullable(impl.taggingDirective())
        .map(value => zio.aws.s3.model.TaggingDirective.wrap(value))
    override val serverSideEncryption
        : Optional[zio.aws.s3.model.ServerSideEncryption] =
      zio.aws.core.internal
        .optionalFromNullable(impl.serverSideEncryption())
        .map(value => zio.aws.s3.model.ServerSideEncryption.wrap(value))
    override val storageClass: Optional[zio.aws.s3.model.StorageClass] =
      zio.aws.core.internal
        .optionalFromNullable(impl.storageClass())
        .map(value => zio.aws.s3.model.StorageClass.wrap(value))
    override val websiteRedirectLocation: Optional[WebsiteRedirectLocation] =
      zio.aws.core.internal
        .optionalFromNullable(impl.websiteRedirectLocation())
        .map(value =>
          zio.aws.s3.model.primitives.WebsiteRedirectLocation(value)
        )
    override val sseCustomerAlgorithm: Optional[SSECustomerAlgorithm] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sseCustomerAlgorithm())
        .map(value => zio.aws.s3.model.primitives.SSECustomerAlgorithm(value))
    override val sseCustomerKey: Optional[SSECustomerKey] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sseCustomerKey())
        .map(value => zio.aws.s3.model.primitives.SSECustomerKey(value))
    override val sseCustomerKeyMD5: Optional[SSECustomerKeyMD5] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sseCustomerKeyMD5())
        .map(value => zio.aws.s3.model.primitives.SSECustomerKeyMD5(value))
    override val ssekmsKeyId: Optional[SSEKMSKeyId] = zio.aws.core.internal
      .optionalFromNullable(impl.ssekmsKeyId())
      .map(value => zio.aws.s3.model.primitives.SSEKMSKeyId(value))
    override val ssekmsEncryptionContext: Optional[SSEKMSEncryptionContext] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ssekmsEncryptionContext())
        .map(value =>
          zio.aws.s3.model.primitives.SSEKMSEncryptionContext(value)
        )
    override val bucketKeyEnabled: Optional[BucketKeyEnabled] =
      zio.aws.core.internal
        .optionalFromNullable(impl.bucketKeyEnabled())
        .map(value => zio.aws.s3.model.primitives.BucketKeyEnabled(value))
    override val copySourceSSECustomerAlgorithm
        : Optional[CopySourceSSECustomerAlgorithm] = zio.aws.core.internal
      .optionalFromNullable(impl.copySourceSSECustomerAlgorithm())
      .map(value =>
        zio.aws.s3.model.primitives.CopySourceSSECustomerAlgorithm(value)
      )
    override val copySourceSSECustomerKey: Optional[CopySourceSSECustomerKey] =
      zio.aws.core.internal
        .optionalFromNullable(impl.copySourceSSECustomerKey())
        .map(value =>
          zio.aws.s3.model.primitives.CopySourceSSECustomerKey(value)
        )
    override val copySourceSSECustomerKeyMD5
        : Optional[CopySourceSSECustomerKeyMD5] = zio.aws.core.internal
      .optionalFromNullable(impl.copySourceSSECustomerKeyMD5())
      .map(value =>
        zio.aws.s3.model.primitives.CopySourceSSECustomerKeyMD5(value)
      )
    override val requestPayer: Optional[zio.aws.s3.model.RequestPayer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.requestPayer())
        .map(value => zio.aws.s3.model.RequestPayer.wrap(value))
    override val tagging: Optional[TaggingHeader] = zio.aws.core.internal
      .optionalFromNullable(impl.tagging())
      .map(value => zio.aws.s3.model.primitives.TaggingHeader(value))
    override val objectLockMode: Optional[zio.aws.s3.model.ObjectLockMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.objectLockMode())
        .map(value => zio.aws.s3.model.ObjectLockMode.wrap(value))
    override val objectLockRetainUntilDate
        : Optional[ObjectLockRetainUntilDate] = zio.aws.core.internal
      .optionalFromNullable(impl.objectLockRetainUntilDate())
      .map(value =>
        zio.aws.s3.model.primitives.ObjectLockRetainUntilDate(value)
      )
    override val objectLockLegalHoldStatus
        : Optional[zio.aws.s3.model.ObjectLockLegalHoldStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.objectLockLegalHoldStatus())
        .map(value => zio.aws.s3.model.ObjectLockLegalHoldStatus.wrap(value))
    override val expectedBucketOwner: Optional[AccountId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.expectedBucketOwner())
        .map(value => zio.aws.s3.model.primitives.AccountId(value))
    override val expectedSourceBucketOwner: Optional[AccountId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.expectedSourceBucketOwner())
        .map(value => zio.aws.s3.model.primitives.AccountId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.CopyObjectRequest
  ): zio.aws.s3.model.CopyObjectRequest.ReadOnly = new Wrapper(impl)
}
