package zio.aws.s3.model
import zio.aws.s3.model.primitives.{
  Expiration,
  SSECustomerAlgorithm,
  SSECustomerKeyMD5,
  SSEKMSEncryptionContext,
  SSEKMSKeyId,
  ObjectVersionId,
  CopySourceVersionId,
  BucketKeyEnabled
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CopyObjectResponse(
    copyObjectResult: Optional[zio.aws.s3.model.CopyObjectResult] =
      Optional.Absent,
    expiration: Optional[Expiration] = Optional.Absent,
    copySourceVersionId: Optional[CopySourceVersionId] = Optional.Absent,
    versionId: Optional[ObjectVersionId] = Optional.Absent,
    serverSideEncryption: Optional[zio.aws.s3.model.ServerSideEncryption] =
      Optional.Absent,
    sseCustomerAlgorithm: Optional[SSECustomerAlgorithm] = Optional.Absent,
    sseCustomerKeyMD5: Optional[SSECustomerKeyMD5] = Optional.Absent,
    ssekmsKeyId: Optional[SSEKMSKeyId] = Optional.Absent,
    ssekmsEncryptionContext: Optional[SSEKMSEncryptionContext] =
      Optional.Absent,
    bucketKeyEnabled: Optional[BucketKeyEnabled] = Optional.Absent,
    requestCharged: Optional[zio.aws.s3.model.RequestCharged] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.CopyObjectResponse = {
    import CopyObjectResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.CopyObjectResponse
      .builder()
      .optionallyWith(copyObjectResult.map(value => value.buildAwsValue()))(
        _.copyObjectResult
      )
      .optionallyWith(
        expiration.map(value => Expiration.unwrap(value): java.lang.String)
      )(_.expiration)
      .optionallyWith(
        copySourceVersionId.map(value =>
          CopySourceVersionId.unwrap(value): java.lang.String
        )
      )(_.copySourceVersionId)
      .optionallyWith(
        versionId.map(value => ObjectVersionId.unwrap(value): java.lang.String)
      )(_.versionId)
      .optionallyWith(serverSideEncryption.map(value => value.unwrap))(
        _.serverSideEncryption
      )
      .optionallyWith(
        sseCustomerAlgorithm.map(value =>
          SSECustomerAlgorithm.unwrap(value): java.lang.String
        )
      )(_.sseCustomerAlgorithm)
      .optionallyWith(
        sseCustomerKeyMD5.map(value =>
          SSECustomerKeyMD5.unwrap(value): java.lang.String
        )
      )(_.sseCustomerKeyMD5)
      .optionallyWith(
        ssekmsKeyId.map(value => SSEKMSKeyId.unwrap(value): java.lang.String)
      )(_.ssekmsKeyId)
      .optionallyWith(
        ssekmsEncryptionContext.map(value =>
          SSEKMSEncryptionContext.unwrap(value): java.lang.String
        )
      )(_.ssekmsEncryptionContext)
      .optionallyWith(
        bucketKeyEnabled.map(value =>
          BucketKeyEnabled.unwrap(value): java.lang.Boolean
        )
      )(_.bucketKeyEnabled)
      .optionallyWith(requestCharged.map(value => value.unwrap))(
        _.requestCharged
      )
      .build()
  }
  def asReadOnly: zio.aws.s3.model.CopyObjectResponse.ReadOnly =
    zio.aws.s3.model.CopyObjectResponse.wrap(buildAwsValue())
}
object CopyObjectResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.CopyObjectResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.CopyObjectResponse =
      zio.aws.s3.model.CopyObjectResponse(
        copyObjectResult.map(value => value.asEditable),
        expiration.map(value => value),
        copySourceVersionId.map(value => value),
        versionId.map(value => value),
        serverSideEncryption.map(value => value),
        sseCustomerAlgorithm.map(value => value),
        sseCustomerKeyMD5.map(value => value),
        ssekmsKeyId.map(value => value),
        ssekmsEncryptionContext.map(value => value),
        bucketKeyEnabled.map(value => value),
        requestCharged.map(value => value)
      )
    def copyObjectResult: Optional[zio.aws.s3.model.CopyObjectResult.ReadOnly]
    def expiration: Optional[Expiration]
    def copySourceVersionId: Optional[CopySourceVersionId]
    def versionId: Optional[ObjectVersionId]
    def serverSideEncryption: Optional[zio.aws.s3.model.ServerSideEncryption]
    def sseCustomerAlgorithm: Optional[SSECustomerAlgorithm]
    def sseCustomerKeyMD5: Optional[SSECustomerKeyMD5]
    def ssekmsKeyId: Optional[SSEKMSKeyId]
    def ssekmsEncryptionContext: Optional[SSEKMSEncryptionContext]
    def bucketKeyEnabled: Optional[BucketKeyEnabled]
    def requestCharged: Optional[zio.aws.s3.model.RequestCharged]
    def getCopyObjectResult
        : ZIO[Any, AwsError, zio.aws.s3.model.CopyObjectResult.ReadOnly] =
      AwsError.unwrapOptionField("copyObjectResult", copyObjectResult)
    def getExpiration: ZIO[Any, AwsError, Expiration] =
      AwsError.unwrapOptionField("expiration", expiration)
    def getCopySourceVersionId: ZIO[Any, AwsError, CopySourceVersionId] =
      AwsError.unwrapOptionField("copySourceVersionId", copySourceVersionId)
    def getVersionId: ZIO[Any, AwsError, ObjectVersionId] =
      AwsError.unwrapOptionField("versionId", versionId)
    def getServerSideEncryption
        : ZIO[Any, AwsError, zio.aws.s3.model.ServerSideEncryption] =
      AwsError.unwrapOptionField("serverSideEncryption", serverSideEncryption)
    def getSseCustomerAlgorithm: ZIO[Any, AwsError, SSECustomerAlgorithm] =
      AwsError.unwrapOptionField("sseCustomerAlgorithm", sseCustomerAlgorithm)
    def getSseCustomerKeyMD5: ZIO[Any, AwsError, SSECustomerKeyMD5] =
      AwsError.unwrapOptionField("sseCustomerKeyMD5", sseCustomerKeyMD5)
    def getSsekmsKeyId: ZIO[Any, AwsError, SSEKMSKeyId] =
      AwsError.unwrapOptionField("ssekmsKeyId", ssekmsKeyId)
    def getSsekmsEncryptionContext
        : ZIO[Any, AwsError, SSEKMSEncryptionContext] = AwsError
      .unwrapOptionField("ssekmsEncryptionContext", ssekmsEncryptionContext)
    def getBucketKeyEnabled: ZIO[Any, AwsError, BucketKeyEnabled] =
      AwsError.unwrapOptionField("bucketKeyEnabled", bucketKeyEnabled)
    def getRequestCharged: ZIO[Any, AwsError, zio.aws.s3.model.RequestCharged] =
      AwsError.unwrapOptionField("requestCharged", requestCharged)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.CopyObjectResponse
  ) extends zio.aws.s3.model.CopyObjectResponse.ReadOnly {
    override val copyObjectResult
        : Optional[zio.aws.s3.model.CopyObjectResult.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.copyObjectResult())
        .map(value => zio.aws.s3.model.CopyObjectResult.wrap(value))
    override val expiration: Optional[Expiration] = zio.aws.core.internal
      .optionalFromNullable(impl.expiration())
      .map(value => zio.aws.s3.model.primitives.Expiration(value))
    override val copySourceVersionId: Optional[CopySourceVersionId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.copySourceVersionId())
        .map(value => zio.aws.s3.model.primitives.CopySourceVersionId(value))
    override val versionId: Optional[ObjectVersionId] = zio.aws.core.internal
      .optionalFromNullable(impl.versionId())
      .map(value => zio.aws.s3.model.primitives.ObjectVersionId(value))
    override val serverSideEncryption
        : Optional[zio.aws.s3.model.ServerSideEncryption] =
      zio.aws.core.internal
        .optionalFromNullable(impl.serverSideEncryption())
        .map(value => zio.aws.s3.model.ServerSideEncryption.wrap(value))
    override val sseCustomerAlgorithm: Optional[SSECustomerAlgorithm] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sseCustomerAlgorithm())
        .map(value => zio.aws.s3.model.primitives.SSECustomerAlgorithm(value))
    override val sseCustomerKeyMD5: Optional[SSECustomerKeyMD5] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sseCustomerKeyMD5())
        .map(value => zio.aws.s3.model.primitives.SSECustomerKeyMD5(value))
    override val ssekmsKeyId: Optional[SSEKMSKeyId] = zio.aws.core.internal
      .optionalFromNullable(impl.ssekmsKeyId())
      .map(value => zio.aws.s3.model.primitives.SSEKMSKeyId(value))
    override val ssekmsEncryptionContext: Optional[SSEKMSEncryptionContext] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ssekmsEncryptionContext())
        .map(value =>
          zio.aws.s3.model.primitives.SSEKMSEncryptionContext(value)
        )
    override val bucketKeyEnabled: Optional[BucketKeyEnabled] =
      zio.aws.core.internal
        .optionalFromNullable(impl.bucketKeyEnabled())
        .map(value => zio.aws.s3.model.primitives.BucketKeyEnabled(value))
    override val requestCharged: Optional[zio.aws.s3.model.RequestCharged] =
      zio.aws.core.internal
        .optionalFromNullable(impl.requestCharged())
        .map(value => zio.aws.s3.model.RequestCharged.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.CopyObjectResponse
  ): zio.aws.s3.model.CopyObjectResponse.ReadOnly = new Wrapper(impl)
}
