package zio.aws.s3.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateBucketConfiguration(
    locationConstraint: Optional[zio.aws.s3.model.BucketLocationConstraint] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.CreateBucketConfiguration = {
    import CreateBucketConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.CreateBucketConfiguration
      .builder()
      .optionallyWith(locationConstraint.map(value => value.unwrap))(
        _.locationConstraint
      )
      .build()
  }
  def asReadOnly: zio.aws.s3.model.CreateBucketConfiguration.ReadOnly =
    zio.aws.s3.model.CreateBucketConfiguration.wrap(buildAwsValue())
}
object CreateBucketConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.CreateBucketConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.CreateBucketConfiguration =
      zio.aws.s3.model
        .CreateBucketConfiguration(locationConstraint.map(value => value))
    def locationConstraint: Optional[zio.aws.s3.model.BucketLocationConstraint]
    def getLocationConstraint
        : ZIO[Any, AwsError, zio.aws.s3.model.BucketLocationConstraint] =
      AwsError.unwrapOptionField("locationConstraint", locationConstraint)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.CreateBucketConfiguration
  ) extends zio.aws.s3.model.CreateBucketConfiguration.ReadOnly {
    override val locationConstraint
        : Optional[zio.aws.s3.model.BucketLocationConstraint] =
      zio.aws.core.internal
        .optionalFromNullable(impl.locationConstraint())
        .map(value => zio.aws.s3.model.BucketLocationConstraint.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.CreateBucketConfiguration
  ): zio.aws.s3.model.CreateBucketConfiguration.ReadOnly = new Wrapper(impl)
}
