package zio.aws.s3.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.s3.model.primitives.{Years, Days}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class DefaultRetention(
    mode: Optional[zio.aws.s3.model.ObjectLockRetentionMode] = Optional.Absent,
    days: Optional[Days] = Optional.Absent,
    years: Optional[Years] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.DefaultRetention = {
    import DefaultRetention.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.DefaultRetention
      .builder()
      .optionallyWith(mode.map(value => value.unwrap))(_.mode)
      .optionallyWith(days.map(value => Days.unwrap(value): Integer))(_.days)
      .optionallyWith(years.map(value => Years.unwrap(value): Integer))(_.years)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.DefaultRetention.ReadOnly =
    zio.aws.s3.model.DefaultRetention.wrap(buildAwsValue())
}
object DefaultRetention {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.DefaultRetention
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.DefaultRetention =
      zio.aws.s3.model.DefaultRetention(
        mode.map(value => value),
        days.map(value => value),
        years.map(value => value)
      )
    def mode: Optional[zio.aws.s3.model.ObjectLockRetentionMode]
    def days: Optional[Days]
    def years: Optional[Years]
    def getMode: ZIO[Any, AwsError, zio.aws.s3.model.ObjectLockRetentionMode] =
      AwsError.unwrapOptionField("mode", mode)
    def getDays: ZIO[Any, AwsError, Days] =
      AwsError.unwrapOptionField("days", days)
    def getYears: ZIO[Any, AwsError, Years] =
      AwsError.unwrapOptionField("years", years)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.DefaultRetention
  ) extends zio.aws.s3.model.DefaultRetention.ReadOnly {
    override val mode: Optional[zio.aws.s3.model.ObjectLockRetentionMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.mode())
        .map(value => zio.aws.s3.model.ObjectLockRetentionMode.wrap(value))
    override val days: Optional[Days] = zio.aws.core.internal
      .optionalFromNullable(impl.days())
      .map(value => zio.aws.s3.model.primitives.Days(value))
    override val years: Optional[Years] = zio.aws.core.internal
      .optionalFromNullable(impl.years())
      .map(value => zio.aws.s3.model.primitives.Years(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.DefaultRetention
  ): zio.aws.s3.model.DefaultRetention.ReadOnly = new Wrapper(impl)
}
