package zio.aws.s3.model
import zio.aws.s3.model.primitives.Quiet
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class Delete(
    objects: Iterable[zio.aws.s3.model.ObjectIdentifier],
    quiet: Optional[Quiet] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.s3.model.Delete = {
    import Delete.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.Delete
      .builder()
      .objects(objects.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        quiet.map(value => Quiet.unwrap(value): java.lang.Boolean)
      )(_.quiet)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.Delete.ReadOnly =
    zio.aws.s3.model.Delete.wrap(buildAwsValue())
}
object Delete {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.s3.model.Delete] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.Delete = zio.aws.s3.model.Delete(
      objects.map { item =>
        item.asEditable
      },
      quiet.map(value => value)
    )
    def objects: List[zio.aws.s3.model.ObjectIdentifier.ReadOnly]
    def quiet: Optional[Quiet]
    def getObjects
        : ZIO[Any, Nothing, List[zio.aws.s3.model.ObjectIdentifier.ReadOnly]] =
      ZIO.succeed(objects)
    def getQuiet: ZIO[Any, AwsError, Quiet] =
      AwsError.unwrapOptionField("quiet", quiet)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.Delete
  ) extends zio.aws.s3.model.Delete.ReadOnly {
    override val objects: List[zio.aws.s3.model.ObjectIdentifier.ReadOnly] =
      impl
        .objects()
        .asScala
        .map { item =>
          zio.aws.s3.model.ObjectIdentifier.wrap(item)
        }
        .toList
    override val quiet: Optional[Quiet] = zio.aws.core.internal
      .optionalFromNullable(impl.quiet())
      .map(value => zio.aws.s3.model.primitives.Quiet(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.Delete
  ): zio.aws.s3.model.Delete.ReadOnly = new Wrapper(impl)
}
