package zio.aws.s3.model
import zio.aws.s3.model.primitives.{
  AccountId,
  BypassGovernanceRetention,
  MFA,
  BucketName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DeleteObjectsRequest(
    bucket: BucketName,
    delete: zio.aws.s3.model.Delete,
    mfa: Optional[MFA] = Optional.Absent,
    requestPayer: Optional[zio.aws.s3.model.RequestPayer] = Optional.Absent,
    bypassGovernanceRetention: Optional[BypassGovernanceRetention] =
      Optional.Absent,
    expectedBucketOwner: Optional[AccountId] = Optional.Absent,
    checksumAlgorithm: Optional[zio.aws.s3.model.ChecksumAlgorithm] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.DeleteObjectsRequest = {
    import DeleteObjectsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.DeleteObjectsRequest
      .builder()
      .bucket(BucketName.unwrap(bucket): java.lang.String)
      .delete(delete.buildAwsValue())
      .optionallyWith(mfa.map(value => MFA.unwrap(value): java.lang.String))(
        _.mfa
      )
      .optionallyWith(requestPayer.map(value => value.unwrap))(_.requestPayer)
      .optionallyWith(
        bypassGovernanceRetention.map(value =>
          BypassGovernanceRetention.unwrap(value): java.lang.Boolean
        )
      )(_.bypassGovernanceRetention)
      .optionallyWith(
        expectedBucketOwner.map(value =>
          AccountId.unwrap(value): java.lang.String
        )
      )(_.expectedBucketOwner)
      .optionallyWith(checksumAlgorithm.map(value => value.unwrap))(
        _.checksumAlgorithm
      )
      .build()
  }
  def asReadOnly: zio.aws.s3.model.DeleteObjectsRequest.ReadOnly =
    zio.aws.s3.model.DeleteObjectsRequest.wrap(buildAwsValue())
}
object DeleteObjectsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.DeleteObjectsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.DeleteObjectsRequest =
      zio.aws.s3.model.DeleteObjectsRequest(
        bucket,
        delete.asEditable,
        mfa.map(value => value),
        requestPayer.map(value => value),
        bypassGovernanceRetention.map(value => value),
        expectedBucketOwner.map(value => value),
        checksumAlgorithm.map(value => value)
      )
    def bucket: BucketName
    def delete: zio.aws.s3.model.Delete.ReadOnly
    def mfa: Optional[MFA]
    def requestPayer: Optional[zio.aws.s3.model.RequestPayer]
    def bypassGovernanceRetention: Optional[BypassGovernanceRetention]
    def expectedBucketOwner: Optional[AccountId]
    def checksumAlgorithm: Optional[zio.aws.s3.model.ChecksumAlgorithm]
    def getBucket: ZIO[Any, Nothing, BucketName] = ZIO.succeed(bucket)
    def getDelete: ZIO[Any, Nothing, zio.aws.s3.model.Delete.ReadOnly] =
      ZIO.succeed(delete)
    def getMfa: ZIO[Any, AwsError, MFA] = AwsError.unwrapOptionField("mfa", mfa)
    def getRequestPayer: ZIO[Any, AwsError, zio.aws.s3.model.RequestPayer] =
      AwsError.unwrapOptionField("requestPayer", requestPayer)
    def getBypassGovernanceRetention
        : ZIO[Any, AwsError, BypassGovernanceRetention] = AwsError
      .unwrapOptionField("bypassGovernanceRetention", bypassGovernanceRetention)
    def getExpectedBucketOwner: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("expectedBucketOwner", expectedBucketOwner)
    def getChecksumAlgorithm
        : ZIO[Any, AwsError, zio.aws.s3.model.ChecksumAlgorithm] =
      AwsError.unwrapOptionField("checksumAlgorithm", checksumAlgorithm)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.DeleteObjectsRequest
  ) extends zio.aws.s3.model.DeleteObjectsRequest.ReadOnly {
    override val bucket: BucketName =
      zio.aws.s3.model.primitives.BucketName(impl.bucket())
    override val delete: zio.aws.s3.model.Delete.ReadOnly =
      zio.aws.s3.model.Delete.wrap(impl.delete())
    override val mfa: Optional[MFA] = zio.aws.core.internal
      .optionalFromNullable(impl.mfa())
      .map(value => zio.aws.s3.model.primitives.MFA(value))
    override val requestPayer: Optional[zio.aws.s3.model.RequestPayer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.requestPayer())
        .map(value => zio.aws.s3.model.RequestPayer.wrap(value))
    override val bypassGovernanceRetention
        : Optional[BypassGovernanceRetention] = zio.aws.core.internal
      .optionalFromNullable(impl.bypassGovernanceRetention())
      .map(value =>
        zio.aws.s3.model.primitives.BypassGovernanceRetention(value)
      )
    override val expectedBucketOwner: Optional[AccountId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.expectedBucketOwner())
        .map(value => zio.aws.s3.model.primitives.AccountId(value))
    override val checksumAlgorithm
        : Optional[zio.aws.s3.model.ChecksumAlgorithm] = zio.aws.core.internal
      .optionalFromNullable(impl.checksumAlgorithm())
      .map(value => zio.aws.s3.model.ChecksumAlgorithm.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.DeleteObjectsRequest
  ): zio.aws.s3.model.DeleteObjectsRequest.ReadOnly = new Wrapper(impl)
}
