package zio.aws.s3.model
import scala.jdk.CollectionConverters.*
sealed trait ExistingObjectReplicationStatus {
  def unwrap
      : software.amazon.awssdk.services.s3.model.ExistingObjectReplicationStatus
}
object ExistingObjectReplicationStatus {
  def wrap(
      value: software.amazon.awssdk.services.s3.model.ExistingObjectReplicationStatus
  ): zio.aws.s3.model.ExistingObjectReplicationStatus = value match {
    case software.amazon.awssdk.services.s3.model.ExistingObjectReplicationStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.s3.model.ExistingObjectReplicationStatus.ENABLED =>
      val r = Enabled
      r
    case software.amazon.awssdk.services.s3.model.ExistingObjectReplicationStatus.DISABLED =>
      val r = Disabled
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.s3.model.ExistingObjectReplicationStatus {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.ExistingObjectReplicationStatus =
      software.amazon.awssdk.services.s3.model.ExistingObjectReplicationStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object Enabled extends zio.aws.s3.model.ExistingObjectReplicationStatus {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.ExistingObjectReplicationStatus =
      software.amazon.awssdk.services.s3.model.ExistingObjectReplicationStatus.ENABLED
  }
  case object Disabled
      extends zio.aws.s3.model.ExistingObjectReplicationStatus {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.ExistingObjectReplicationStatus =
      software.amazon.awssdk.services.s3.model.ExistingObjectReplicationStatus.DISABLED
  }
}
