package zio.aws.s3.model
import zio.aws.s3.model.primitives.{AccountId, BucketName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetBucketAccelerateConfigurationRequest(
    bucket: BucketName,
    expectedBucketOwner: Optional[AccountId] = Optional.Absent,
    requestPayer: Optional[zio.aws.s3.model.RequestPayer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.GetBucketAccelerateConfigurationRequest = {
    import GetBucketAccelerateConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.GetBucketAccelerateConfigurationRequest
      .builder()
      .bucket(BucketName.unwrap(bucket): java.lang.String)
      .optionallyWith(
        expectedBucketOwner.map(value =>
          AccountId.unwrap(value): java.lang.String
        )
      )(_.expectedBucketOwner)
      .optionallyWith(requestPayer.map(value => value.unwrap))(_.requestPayer)
      .build()
  }
  def asReadOnly
      : zio.aws.s3.model.GetBucketAccelerateConfigurationRequest.ReadOnly =
    zio.aws.s3.model.GetBucketAccelerateConfigurationRequest
      .wrap(buildAwsValue())
}
object GetBucketAccelerateConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.GetBucketAccelerateConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.GetBucketAccelerateConfigurationRequest =
      zio.aws.s3.model.GetBucketAccelerateConfigurationRequest(
        bucket,
        expectedBucketOwner.map(value => value),
        requestPayer.map(value => value)
      )
    def bucket: BucketName
    def expectedBucketOwner: Optional[AccountId]
    def requestPayer: Optional[zio.aws.s3.model.RequestPayer]
    def getBucket: ZIO[Any, Nothing, BucketName] = ZIO.succeed(bucket)
    def getExpectedBucketOwner: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("expectedBucketOwner", expectedBucketOwner)
    def getRequestPayer: ZIO[Any, AwsError, zio.aws.s3.model.RequestPayer] =
      AwsError.unwrapOptionField("requestPayer", requestPayer)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.GetBucketAccelerateConfigurationRequest
  ) extends zio.aws.s3.model.GetBucketAccelerateConfigurationRequest.ReadOnly {
    override val bucket: BucketName =
      zio.aws.s3.model.primitives.BucketName(impl.bucket())
    override val expectedBucketOwner: Optional[AccountId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.expectedBucketOwner())
        .map(value => zio.aws.s3.model.primitives.AccountId(value))
    override val requestPayer: Optional[zio.aws.s3.model.RequestPayer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.requestPayer())
        .map(value => zio.aws.s3.model.RequestPayer.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.GetBucketAccelerateConfigurationRequest
  ): zio.aws.s3.model.GetBucketAccelerateConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
