package zio.aws.s3.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetBucketAccelerateConfigurationResponse(
    status: Optional[zio.aws.s3.model.BucketAccelerateStatus] = Optional.Absent,
    requestCharged: Optional[zio.aws.s3.model.RequestCharged] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.GetBucketAccelerateConfigurationResponse = {
    import GetBucketAccelerateConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.GetBucketAccelerateConfigurationResponse
      .builder()
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(requestCharged.map(value => value.unwrap))(
        _.requestCharged
      )
      .build()
  }
  def asReadOnly
      : zio.aws.s3.model.GetBucketAccelerateConfigurationResponse.ReadOnly =
    zio.aws.s3.model.GetBucketAccelerateConfigurationResponse
      .wrap(buildAwsValue())
}
object GetBucketAccelerateConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.GetBucketAccelerateConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.GetBucketAccelerateConfigurationResponse =
      zio.aws.s3.model.GetBucketAccelerateConfigurationResponse(
        status.map(value => value),
        requestCharged.map(value => value)
      )
    def status: Optional[zio.aws.s3.model.BucketAccelerateStatus]
    def requestCharged: Optional[zio.aws.s3.model.RequestCharged]
    def getStatus: ZIO[Any, AwsError, zio.aws.s3.model.BucketAccelerateStatus] =
      AwsError.unwrapOptionField("status", status)
    def getRequestCharged: ZIO[Any, AwsError, zio.aws.s3.model.RequestCharged] =
      AwsError.unwrapOptionField("requestCharged", requestCharged)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.GetBucketAccelerateConfigurationResponse
  ) extends zio.aws.s3.model.GetBucketAccelerateConfigurationResponse.ReadOnly {
    override val status: Optional[zio.aws.s3.model.BucketAccelerateStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.s3.model.BucketAccelerateStatus.wrap(value))
    override val requestCharged: Optional[zio.aws.s3.model.RequestCharged] =
      zio.aws.core.internal
        .optionalFromNullable(impl.requestCharged())
        .map(value => zio.aws.s3.model.RequestCharged.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.GetBucketAccelerateConfigurationResponse
  ): zio.aws.s3.model.GetBucketAccelerateConfigurationResponse.ReadOnly =
    new Wrapper(impl)
}
