package zio.aws.s3.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetBucketAclResponse(
    owner: Optional[zio.aws.s3.model.Owner] = Optional.Absent,
    grants: Optional[Iterable[zio.aws.s3.model.Grant]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.GetBucketAclResponse = {
    import GetBucketAclResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.GetBucketAclResponse
      .builder()
      .optionallyWith(owner.map(value => value.buildAwsValue()))(_.owner)
      .optionallyWith(
        grants.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.grants)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.GetBucketAclResponse.ReadOnly =
    zio.aws.s3.model.GetBucketAclResponse.wrap(buildAwsValue())
}
object GetBucketAclResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.GetBucketAclResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.GetBucketAclResponse =
      zio.aws.s3.model.GetBucketAclResponse(
        owner.map(value => value.asEditable),
        grants.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def owner: Optional[zio.aws.s3.model.Owner.ReadOnly]
    def grants: Optional[List[zio.aws.s3.model.Grant.ReadOnly]]
    def getOwner: ZIO[Any, AwsError, zio.aws.s3.model.Owner.ReadOnly] =
      AwsError.unwrapOptionField("owner", owner)
    def getGrants: ZIO[Any, AwsError, List[zio.aws.s3.model.Grant.ReadOnly]] =
      AwsError.unwrapOptionField("grants", grants)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.GetBucketAclResponse
  ) extends zio.aws.s3.model.GetBucketAclResponse.ReadOnly {
    override val owner: Optional[zio.aws.s3.model.Owner.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.owner())
        .map(value => zio.aws.s3.model.Owner.wrap(value))
    override val grants: Optional[List[zio.aws.s3.model.Grant.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.grants())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.s3.model.Grant.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.GetBucketAclResponse
  ): zio.aws.s3.model.GetBucketAclResponse.ReadOnly = new Wrapper(impl)
}
