package zio.aws.s3.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetBucketEncryptionResponse(
    serverSideEncryptionConfiguration: Optional[
      zio.aws.s3.model.ServerSideEncryptionConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.GetBucketEncryptionResponse = {
    import GetBucketEncryptionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.GetBucketEncryptionResponse
      .builder()
      .optionallyWith(
        serverSideEncryptionConfiguration.map(value => value.buildAwsValue())
      )(_.serverSideEncryptionConfiguration)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.GetBucketEncryptionResponse.ReadOnly =
    zio.aws.s3.model.GetBucketEncryptionResponse.wrap(buildAwsValue())
}
object GetBucketEncryptionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.GetBucketEncryptionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.GetBucketEncryptionResponse =
      zio.aws.s3.model.GetBucketEncryptionResponse(
        serverSideEncryptionConfiguration.map(value => value.asEditable)
      )
    def serverSideEncryptionConfiguration
        : Optional[zio.aws.s3.model.ServerSideEncryptionConfiguration.ReadOnly]
    def getServerSideEncryptionConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.s3.model.ServerSideEncryptionConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "serverSideEncryptionConfiguration",
      serverSideEncryptionConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.GetBucketEncryptionResponse
  ) extends zio.aws.s3.model.GetBucketEncryptionResponse.ReadOnly {
    override val serverSideEncryptionConfiguration: Optional[
      zio.aws.s3.model.ServerSideEncryptionConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.serverSideEncryptionConfiguration())
      .map(value =>
        zio.aws.s3.model.ServerSideEncryptionConfiguration.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.GetBucketEncryptionResponse
  ): zio.aws.s3.model.GetBucketEncryptionResponse.ReadOnly = new Wrapper(impl)
}
