package zio.aws.s3.model
import zio.aws.s3.model.primitives.{AccountId, InventoryId, BucketName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetBucketInventoryConfigurationRequest(
    bucket: BucketName,
    id: InventoryId,
    expectedBucketOwner: Optional[AccountId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.GetBucketInventoryConfigurationRequest = {
    import GetBucketInventoryConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.GetBucketInventoryConfigurationRequest
      .builder()
      .bucket(BucketName.unwrap(bucket): java.lang.String)
      .id(InventoryId.unwrap(id): java.lang.String)
      .optionallyWith(
        expectedBucketOwner.map(value =>
          AccountId.unwrap(value): java.lang.String
        )
      )(_.expectedBucketOwner)
      .build()
  }
  def asReadOnly
      : zio.aws.s3.model.GetBucketInventoryConfigurationRequest.ReadOnly =
    zio.aws.s3.model.GetBucketInventoryConfigurationRequest
      .wrap(buildAwsValue())
}
object GetBucketInventoryConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.GetBucketInventoryConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.GetBucketInventoryConfigurationRequest =
      zio.aws.s3.model.GetBucketInventoryConfigurationRequest(
        bucket,
        id,
        expectedBucketOwner.map(value => value)
      )
    def bucket: BucketName
    def id: InventoryId
    def expectedBucketOwner: Optional[AccountId]
    def getBucket: ZIO[Any, Nothing, BucketName] = ZIO.succeed(bucket)
    def getId: ZIO[Any, Nothing, InventoryId] = ZIO.succeed(id)
    def getExpectedBucketOwner: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("expectedBucketOwner", expectedBucketOwner)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.GetBucketInventoryConfigurationRequest
  ) extends zio.aws.s3.model.GetBucketInventoryConfigurationRequest.ReadOnly {
    override val bucket: BucketName =
      zio.aws.s3.model.primitives.BucketName(impl.bucket())
    override val id: InventoryId =
      zio.aws.s3.model.primitives.InventoryId(impl.id())
    override val expectedBucketOwner: Optional[AccountId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.expectedBucketOwner())
        .map(value => zio.aws.s3.model.primitives.AccountId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.GetBucketInventoryConfigurationRequest
  ): zio.aws.s3.model.GetBucketInventoryConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
