package zio.aws.s3.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetBucketWebsiteResponse(
    redirectAllRequestsTo: Optional[zio.aws.s3.model.RedirectAllRequestsTo] =
      Optional.Absent,
    indexDocument: Optional[zio.aws.s3.model.IndexDocument] = Optional.Absent,
    errorDocument: Optional[zio.aws.s3.model.ErrorDocument] = Optional.Absent,
    routingRules: Optional[Iterable[zio.aws.s3.model.RoutingRule]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.GetBucketWebsiteResponse = {
    import GetBucketWebsiteResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.GetBucketWebsiteResponse
      .builder()
      .optionallyWith(
        redirectAllRequestsTo.map(value => value.buildAwsValue())
      )(_.redirectAllRequestsTo)
      .optionallyWith(indexDocument.map(value => value.buildAwsValue()))(
        _.indexDocument
      )
      .optionallyWith(errorDocument.map(value => value.buildAwsValue()))(
        _.errorDocument
      )
      .optionallyWith(
        routingRules.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.routingRules)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.GetBucketWebsiteResponse.ReadOnly =
    zio.aws.s3.model.GetBucketWebsiteResponse.wrap(buildAwsValue())
}
object GetBucketWebsiteResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.GetBucketWebsiteResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.GetBucketWebsiteResponse =
      zio.aws.s3.model.GetBucketWebsiteResponse(
        redirectAllRequestsTo.map(value => value.asEditable),
        indexDocument.map(value => value.asEditable),
        errorDocument.map(value => value.asEditable),
        routingRules.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def redirectAllRequestsTo
        : Optional[zio.aws.s3.model.RedirectAllRequestsTo.ReadOnly]
    def indexDocument: Optional[zio.aws.s3.model.IndexDocument.ReadOnly]
    def errorDocument: Optional[zio.aws.s3.model.ErrorDocument.ReadOnly]
    def routingRules: Optional[List[zio.aws.s3.model.RoutingRule.ReadOnly]]
    def getRedirectAllRequestsTo
        : ZIO[Any, AwsError, zio.aws.s3.model.RedirectAllRequestsTo.ReadOnly] =
      AwsError.unwrapOptionField("redirectAllRequestsTo", redirectAllRequestsTo)
    def getIndexDocument
        : ZIO[Any, AwsError, zio.aws.s3.model.IndexDocument.ReadOnly] =
      AwsError.unwrapOptionField("indexDocument", indexDocument)
    def getErrorDocument
        : ZIO[Any, AwsError, zio.aws.s3.model.ErrorDocument.ReadOnly] =
      AwsError.unwrapOptionField("errorDocument", errorDocument)
    def getRoutingRules
        : ZIO[Any, AwsError, List[zio.aws.s3.model.RoutingRule.ReadOnly]] =
      AwsError.unwrapOptionField("routingRules", routingRules)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.GetBucketWebsiteResponse
  ) extends zio.aws.s3.model.GetBucketWebsiteResponse.ReadOnly {
    override val redirectAllRequestsTo
        : Optional[zio.aws.s3.model.RedirectAllRequestsTo.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.redirectAllRequestsTo())
        .map(value => zio.aws.s3.model.RedirectAllRequestsTo.wrap(value))
    override val indexDocument
        : Optional[zio.aws.s3.model.IndexDocument.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.indexDocument())
        .map(value => zio.aws.s3.model.IndexDocument.wrap(value))
    override val errorDocument
        : Optional[zio.aws.s3.model.ErrorDocument.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.errorDocument())
        .map(value => zio.aws.s3.model.ErrorDocument.wrap(value))
    override val routingRules
        : Optional[List[zio.aws.s3.model.RoutingRule.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.routingRules())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.s3.model.RoutingRule.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.GetBucketWebsiteResponse
  ): zio.aws.s3.model.GetBucketWebsiteResponse.ReadOnly = new Wrapper(impl)
}
