package zio.aws.s3.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetObjectAclResponse(
    owner: Optional[zio.aws.s3.model.Owner] = Optional.Absent,
    grants: Optional[Iterable[zio.aws.s3.model.Grant]] = Optional.Absent,
    requestCharged: Optional[zio.aws.s3.model.RequestCharged] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.GetObjectAclResponse = {
    import GetObjectAclResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.GetObjectAclResponse
      .builder()
      .optionallyWith(owner.map(value => value.buildAwsValue()))(_.owner)
      .optionallyWith(
        grants.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.grants)
      .optionallyWith(requestCharged.map(value => value.unwrap))(
        _.requestCharged
      )
      .build()
  }
  def asReadOnly: zio.aws.s3.model.GetObjectAclResponse.ReadOnly =
    zio.aws.s3.model.GetObjectAclResponse.wrap(buildAwsValue())
}
object GetObjectAclResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.GetObjectAclResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.GetObjectAclResponse =
      zio.aws.s3.model.GetObjectAclResponse(
        owner.map(value => value.asEditable),
        grants.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        requestCharged.map(value => value)
      )
    def owner: Optional[zio.aws.s3.model.Owner.ReadOnly]
    def grants: Optional[List[zio.aws.s3.model.Grant.ReadOnly]]
    def requestCharged: Optional[zio.aws.s3.model.RequestCharged]
    def getOwner: ZIO[Any, AwsError, zio.aws.s3.model.Owner.ReadOnly] =
      AwsError.unwrapOptionField("owner", owner)
    def getGrants: ZIO[Any, AwsError, List[zio.aws.s3.model.Grant.ReadOnly]] =
      AwsError.unwrapOptionField("grants", grants)
    def getRequestCharged: ZIO[Any, AwsError, zio.aws.s3.model.RequestCharged] =
      AwsError.unwrapOptionField("requestCharged", requestCharged)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.GetObjectAclResponse
  ) extends zio.aws.s3.model.GetObjectAclResponse.ReadOnly {
    override val owner: Optional[zio.aws.s3.model.Owner.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.owner())
        .map(value => zio.aws.s3.model.Owner.wrap(value))
    override val grants: Optional[List[zio.aws.s3.model.Grant.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.grants())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.s3.model.Grant.wrap(item)
          }.toList
        )
    override val requestCharged: Optional[zio.aws.s3.model.RequestCharged] =
      zio.aws.core.internal
        .optionalFromNullable(impl.requestCharged())
        .map(value => zio.aws.s3.model.RequestCharged.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.GetObjectAclResponse
  ): zio.aws.s3.model.GetObjectAclResponse.ReadOnly = new Wrapper(impl)
}
