package zio.aws.s3.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.s3.model.primitives.{
  ETag,
  DeleteMarker,
  LastModified,
  ObjectVersionId,
  ObjectSize
}
import scala.jdk.CollectionConverters.*
final case class GetObjectAttributesResponse(
    deleteMarker: Optional[DeleteMarker] = Optional.Absent,
    lastModified: Optional[LastModified] = Optional.Absent,
    versionId: Optional[ObjectVersionId] = Optional.Absent,
    requestCharged: Optional[zio.aws.s3.model.RequestCharged] = Optional.Absent,
    eTag: Optional[ETag] = Optional.Absent,
    checksum: Optional[zio.aws.s3.model.Checksum] = Optional.Absent,
    objectParts: Optional[zio.aws.s3.model.GetObjectAttributesParts] =
      Optional.Absent,
    storageClass: Optional[zio.aws.s3.model.StorageClass] = Optional.Absent,
    objectSize: Optional[ObjectSize] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.GetObjectAttributesResponse = {
    import GetObjectAttributesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.GetObjectAttributesResponse
      .builder()
      .optionallyWith(
        deleteMarker.map(value => DeleteMarker.unwrap(value): java.lang.Boolean)
      )(_.deleteMarker)
      .optionallyWith(
        lastModified.map(value => LastModified.unwrap(value): Instant)
      )(_.lastModified)
      .optionallyWith(
        versionId.map(value => ObjectVersionId.unwrap(value): java.lang.String)
      )(_.versionId)
      .optionallyWith(requestCharged.map(value => value.unwrap))(
        _.requestCharged
      )
      .optionallyWith(eTag.map(value => ETag.unwrap(value): java.lang.String))(
        _.eTag
      )
      .optionallyWith(checksum.map(value => value.buildAwsValue()))(_.checksum)
      .optionallyWith(objectParts.map(value => value.buildAwsValue()))(
        _.objectParts
      )
      .optionallyWith(storageClass.map(value => value.unwrap))(_.storageClass)
      .optionallyWith(
        objectSize.map(value => ObjectSize.unwrap(value): java.lang.Long)
      )(_.objectSize)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.GetObjectAttributesResponse.ReadOnly =
    zio.aws.s3.model.GetObjectAttributesResponse.wrap(buildAwsValue())
}
object GetObjectAttributesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.GetObjectAttributesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.GetObjectAttributesResponse =
      zio.aws.s3.model.GetObjectAttributesResponse(
        deleteMarker.map(value => value),
        lastModified.map(value => value),
        versionId.map(value => value),
        requestCharged.map(value => value),
        eTag.map(value => value),
        checksum.map(value => value.asEditable),
        objectParts.map(value => value.asEditable),
        storageClass.map(value => value),
        objectSize.map(value => value)
      )
    def deleteMarker: Optional[DeleteMarker]
    def lastModified: Optional[LastModified]
    def versionId: Optional[ObjectVersionId]
    def requestCharged: Optional[zio.aws.s3.model.RequestCharged]
    def eTag: Optional[ETag]
    def checksum: Optional[zio.aws.s3.model.Checksum.ReadOnly]
    def objectParts
        : Optional[zio.aws.s3.model.GetObjectAttributesParts.ReadOnly]
    def storageClass: Optional[zio.aws.s3.model.StorageClass]
    def objectSize: Optional[ObjectSize]
    def getDeleteMarker: ZIO[Any, AwsError, DeleteMarker] =
      AwsError.unwrapOptionField("deleteMarker", deleteMarker)
    def getLastModified: ZIO[Any, AwsError, LastModified] =
      AwsError.unwrapOptionField("lastModified", lastModified)
    def getVersionId: ZIO[Any, AwsError, ObjectVersionId] =
      AwsError.unwrapOptionField("versionId", versionId)
    def getRequestCharged: ZIO[Any, AwsError, zio.aws.s3.model.RequestCharged] =
      AwsError.unwrapOptionField("requestCharged", requestCharged)
    def getETag: ZIO[Any, AwsError, ETag] =
      AwsError.unwrapOptionField("eTag", eTag)
    def getChecksum: ZIO[Any, AwsError, zio.aws.s3.model.Checksum.ReadOnly] =
      AwsError.unwrapOptionField("checksum", checksum)
    def getObjectParts: ZIO[
      Any,
      AwsError,
      zio.aws.s3.model.GetObjectAttributesParts.ReadOnly
    ] = AwsError.unwrapOptionField("objectParts", objectParts)
    def getStorageClass: ZIO[Any, AwsError, zio.aws.s3.model.StorageClass] =
      AwsError.unwrapOptionField("storageClass", storageClass)
    def getObjectSize: ZIO[Any, AwsError, ObjectSize] =
      AwsError.unwrapOptionField("objectSize", objectSize)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.GetObjectAttributesResponse
  ) extends zio.aws.s3.model.GetObjectAttributesResponse.ReadOnly {
    override val deleteMarker: Optional[DeleteMarker] = zio.aws.core.internal
      .optionalFromNullable(impl.deleteMarker())
      .map(value => zio.aws.s3.model.primitives.DeleteMarker(value))
    override val lastModified: Optional[LastModified] = zio.aws.core.internal
      .optionalFromNullable(impl.lastModified())
      .map(value => zio.aws.s3.model.primitives.LastModified(value))
    override val versionId: Optional[ObjectVersionId] = zio.aws.core.internal
      .optionalFromNullable(impl.versionId())
      .map(value => zio.aws.s3.model.primitives.ObjectVersionId(value))
    override val requestCharged: Optional[zio.aws.s3.model.RequestCharged] =
      zio.aws.core.internal
        .optionalFromNullable(impl.requestCharged())
        .map(value => zio.aws.s3.model.RequestCharged.wrap(value))
    override val eTag: Optional[ETag] = zio.aws.core.internal
      .optionalFromNullable(impl.eTag())
      .map(value => zio.aws.s3.model.primitives.ETag(value))
    override val checksum: Optional[zio.aws.s3.model.Checksum.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.checksum())
        .map(value => zio.aws.s3.model.Checksum.wrap(value))
    override val objectParts
        : Optional[zio.aws.s3.model.GetObjectAttributesParts.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.objectParts())
        .map(value => zio.aws.s3.model.GetObjectAttributesParts.wrap(value))
    override val storageClass: Optional[zio.aws.s3.model.StorageClass] =
      zio.aws.core.internal
        .optionalFromNullable(impl.storageClass())
        .map(value => zio.aws.s3.model.StorageClass.wrap(value))
    override val objectSize: Optional[ObjectSize] = zio.aws.core.internal
      .optionalFromNullable(impl.objectSize())
      .map(value => zio.aws.s3.model.primitives.ObjectSize(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.GetObjectAttributesResponse
  ): zio.aws.s3.model.GetObjectAttributesResponse.ReadOnly = new Wrapper(impl)
}
