package zio.aws.s3.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetObjectLockConfigurationResponse(
    objectLockConfiguration: Optional[
      zio.aws.s3.model.ObjectLockConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.GetObjectLockConfigurationResponse = {
    import GetObjectLockConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.GetObjectLockConfigurationResponse
      .builder()
      .optionallyWith(
        objectLockConfiguration.map(value => value.buildAwsValue())
      )(_.objectLockConfiguration)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.GetObjectLockConfigurationResponse.ReadOnly =
    zio.aws.s3.model.GetObjectLockConfigurationResponse.wrap(buildAwsValue())
}
object GetObjectLockConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.GetObjectLockConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.GetObjectLockConfigurationResponse =
      zio.aws.s3.model.GetObjectLockConfigurationResponse(
        objectLockConfiguration.map(value => value.asEditable)
      )
    def objectLockConfiguration
        : Optional[zio.aws.s3.model.ObjectLockConfiguration.ReadOnly]
    def getObjectLockConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.s3.model.ObjectLockConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "objectLockConfiguration",
      objectLockConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.GetObjectLockConfigurationResponse
  ) extends zio.aws.s3.model.GetObjectLockConfigurationResponse.ReadOnly {
    override val objectLockConfiguration
        : Optional[zio.aws.s3.model.ObjectLockConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.objectLockConfiguration())
        .map(value => zio.aws.s3.model.ObjectLockConfiguration.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.GetObjectLockConfigurationResponse
  ): zio.aws.s3.model.GetObjectLockConfigurationResponse.ReadOnly = new Wrapper(
    impl
  )
}
