package zio.aws.s3.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.s3.model.primitives.{
  SSECustomerKey,
  ResponseContentLanguage,
  AccountId,
  ResponseExpires,
  ResponseContentType,
  SSECustomerAlgorithm,
  IfModifiedSince,
  IfNoneMatch,
  IfMatch,
  SSECustomerKeyMD5,
  ObjectKey,
  ResponseContentEncoding,
  BucketName,
  IfUnmodifiedSince,
  ResponseContentDisposition,
  ResponseCacheControl,
  ObjectVersionId,
  PartNumber
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class GetObjectRequest(
    bucket: BucketName,
    ifMatch: Optional[IfMatch] = Optional.Absent,
    ifModifiedSince: Optional[IfModifiedSince] = Optional.Absent,
    ifNoneMatch: Optional[IfNoneMatch] = Optional.Absent,
    ifUnmodifiedSince: Optional[IfUnmodifiedSince] = Optional.Absent,
    key: ObjectKey,
    range: Optional[zio.aws.s3.model.primitives.Range] = Optional.Absent,
    responseCacheControl: Optional[ResponseCacheControl] = Optional.Absent,
    responseContentDisposition: Optional[ResponseContentDisposition] =
      Optional.Absent,
    responseContentEncoding: Optional[ResponseContentEncoding] =
      Optional.Absent,
    responseContentLanguage: Optional[ResponseContentLanguage] =
      Optional.Absent,
    responseContentType: Optional[ResponseContentType] = Optional.Absent,
    responseExpires: Optional[ResponseExpires] = Optional.Absent,
    versionId: Optional[ObjectVersionId] = Optional.Absent,
    sseCustomerAlgorithm: Optional[SSECustomerAlgorithm] = Optional.Absent,
    sseCustomerKey: Optional[SSECustomerKey] = Optional.Absent,
    sseCustomerKeyMD5: Optional[SSECustomerKeyMD5] = Optional.Absent,
    requestPayer: Optional[zio.aws.s3.model.RequestPayer] = Optional.Absent,
    partNumber: Optional[PartNumber] = Optional.Absent,
    expectedBucketOwner: Optional[AccountId] = Optional.Absent,
    checksumMode: Optional[zio.aws.s3.model.ChecksumMode] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.GetObjectRequest = {
    import GetObjectRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.GetObjectRequest
      .builder()
      .bucket(BucketName.unwrap(bucket): java.lang.String)
      .optionallyWith(
        ifMatch.map(value => IfMatch.unwrap(value): java.lang.String)
      )(_.ifMatch)
      .optionallyWith(
        ifModifiedSince.map(value => IfModifiedSince.unwrap(value): Instant)
      )(_.ifModifiedSince)
      .optionallyWith(
        ifNoneMatch.map(value => IfNoneMatch.unwrap(value): java.lang.String)
      )(_.ifNoneMatch)
      .optionallyWith(
        ifUnmodifiedSince.map(value => IfUnmodifiedSince.unwrap(value): Instant)
      )(_.ifUnmodifiedSince)
      .key(ObjectKey.unwrap(key): java.lang.String)
      .optionallyWith(
        range.map(value =>
          zio.aws.s3.model.primitives.Range.unwrap(value): java.lang.String
        )
      )(_.range)
      .optionallyWith(
        responseCacheControl.map(value =>
          ResponseCacheControl.unwrap(value): java.lang.String
        )
      )(_.responseCacheControl)
      .optionallyWith(
        responseContentDisposition.map(value =>
          ResponseContentDisposition.unwrap(value): java.lang.String
        )
      )(_.responseContentDisposition)
      .optionallyWith(
        responseContentEncoding.map(value =>
          ResponseContentEncoding.unwrap(value): java.lang.String
        )
      )(_.responseContentEncoding)
      .optionallyWith(
        responseContentLanguage.map(value =>
          ResponseContentLanguage.unwrap(value): java.lang.String
        )
      )(_.responseContentLanguage)
      .optionallyWith(
        responseContentType.map(value =>
          ResponseContentType.unwrap(value): java.lang.String
        )
      )(_.responseContentType)
      .optionallyWith(
        responseExpires.map(value => ResponseExpires.unwrap(value): Instant)
      )(_.responseExpires)
      .optionallyWith(
        versionId.map(value => ObjectVersionId.unwrap(value): java.lang.String)
      )(_.versionId)
      .optionallyWith(
        sseCustomerAlgorithm.map(value =>
          SSECustomerAlgorithm.unwrap(value): java.lang.String
        )
      )(_.sseCustomerAlgorithm)
      .optionallyWith(
        sseCustomerKey.map(value =>
          SSECustomerKey.unwrap(value): java.lang.String
        )
      )(_.sseCustomerKey)
      .optionallyWith(
        sseCustomerKeyMD5.map(value =>
          SSECustomerKeyMD5.unwrap(value): java.lang.String
        )
      )(_.sseCustomerKeyMD5)
      .optionallyWith(requestPayer.map(value => value.unwrap))(_.requestPayer)
      .optionallyWith(
        partNumber.map(value => PartNumber.unwrap(value): Integer)
      )(_.partNumber)
      .optionallyWith(
        expectedBucketOwner.map(value =>
          AccountId.unwrap(value): java.lang.String
        )
      )(_.expectedBucketOwner)
      .optionallyWith(checksumMode.map(value => value.unwrap))(_.checksumMode)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.GetObjectRequest.ReadOnly =
    zio.aws.s3.model.GetObjectRequest.wrap(buildAwsValue())
}
object GetObjectRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.GetObjectRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.GetObjectRequest =
      zio.aws.s3.model.GetObjectRequest(
        bucket,
        ifMatch.map(value => value),
        ifModifiedSince.map(value => value),
        ifNoneMatch.map(value => value),
        ifUnmodifiedSince.map(value => value),
        key,
        range.map(value => value),
        responseCacheControl.map(value => value),
        responseContentDisposition.map(value => value),
        responseContentEncoding.map(value => value),
        responseContentLanguage.map(value => value),
        responseContentType.map(value => value),
        responseExpires.map(value => value),
        versionId.map(value => value),
        sseCustomerAlgorithm.map(value => value),
        sseCustomerKey.map(value => value),
        sseCustomerKeyMD5.map(value => value),
        requestPayer.map(value => value),
        partNumber.map(value => value),
        expectedBucketOwner.map(value => value),
        checksumMode.map(value => value)
      )
    def bucket: BucketName
    def ifMatch: Optional[IfMatch]
    def ifModifiedSince: Optional[IfModifiedSince]
    def ifNoneMatch: Optional[IfNoneMatch]
    def ifUnmodifiedSince: Optional[IfUnmodifiedSince]
    def key: ObjectKey
    def range: Optional[zio.aws.s3.model.primitives.Range]
    def responseCacheControl: Optional[ResponseCacheControl]
    def responseContentDisposition: Optional[ResponseContentDisposition]
    def responseContentEncoding: Optional[ResponseContentEncoding]
    def responseContentLanguage: Optional[ResponseContentLanguage]
    def responseContentType: Optional[ResponseContentType]
    def responseExpires: Optional[ResponseExpires]
    def versionId: Optional[ObjectVersionId]
    def sseCustomerAlgorithm: Optional[SSECustomerAlgorithm]
    def sseCustomerKey: Optional[SSECustomerKey]
    def sseCustomerKeyMD5: Optional[SSECustomerKeyMD5]
    def requestPayer: Optional[zio.aws.s3.model.RequestPayer]
    def partNumber: Optional[PartNumber]
    def expectedBucketOwner: Optional[AccountId]
    def checksumMode: Optional[zio.aws.s3.model.ChecksumMode]
    def getBucket: ZIO[Any, Nothing, BucketName] = ZIO.succeed(bucket)
    def getIfMatch: ZIO[Any, AwsError, IfMatch] =
      AwsError.unwrapOptionField("ifMatch", ifMatch)
    def getIfModifiedSince: ZIO[Any, AwsError, IfModifiedSince] =
      AwsError.unwrapOptionField("ifModifiedSince", ifModifiedSince)
    def getIfNoneMatch: ZIO[Any, AwsError, IfNoneMatch] =
      AwsError.unwrapOptionField("ifNoneMatch", ifNoneMatch)
    def getIfUnmodifiedSince: ZIO[Any, AwsError, IfUnmodifiedSince] =
      AwsError.unwrapOptionField("ifUnmodifiedSince", ifUnmodifiedSince)
    def getKey: ZIO[Any, Nothing, ObjectKey] = ZIO.succeed(key)
    def getRange: ZIO[Any, AwsError, zio.aws.s3.model.primitives.Range] =
      AwsError.unwrapOptionField("range", range)
    def getResponseCacheControl: ZIO[Any, AwsError, ResponseCacheControl] =
      AwsError.unwrapOptionField("responseCacheControl", responseCacheControl)
    def getResponseContentDisposition
        : ZIO[Any, AwsError, ResponseContentDisposition] =
      AwsError.unwrapOptionField(
        "responseContentDisposition",
        responseContentDisposition
      )
    def getResponseContentEncoding
        : ZIO[Any, AwsError, ResponseContentEncoding] = AwsError
      .unwrapOptionField("responseContentEncoding", responseContentEncoding)
    def getResponseContentLanguage
        : ZIO[Any, AwsError, ResponseContentLanguage] = AwsError
      .unwrapOptionField("responseContentLanguage", responseContentLanguage)
    def getResponseContentType: ZIO[Any, AwsError, ResponseContentType] =
      AwsError.unwrapOptionField("responseContentType", responseContentType)
    def getResponseExpires: ZIO[Any, AwsError, ResponseExpires] =
      AwsError.unwrapOptionField("responseExpires", responseExpires)
    def getVersionId: ZIO[Any, AwsError, ObjectVersionId] =
      AwsError.unwrapOptionField("versionId", versionId)
    def getSseCustomerAlgorithm: ZIO[Any, AwsError, SSECustomerAlgorithm] =
      AwsError.unwrapOptionField("sseCustomerAlgorithm", sseCustomerAlgorithm)
    def getSseCustomerKey: ZIO[Any, AwsError, SSECustomerKey] =
      AwsError.unwrapOptionField("sseCustomerKey", sseCustomerKey)
    def getSseCustomerKeyMD5: ZIO[Any, AwsError, SSECustomerKeyMD5] =
      AwsError.unwrapOptionField("sseCustomerKeyMD5", sseCustomerKeyMD5)
    def getRequestPayer: ZIO[Any, AwsError, zio.aws.s3.model.RequestPayer] =
      AwsError.unwrapOptionField("requestPayer", requestPayer)
    def getPartNumber: ZIO[Any, AwsError, PartNumber] =
      AwsError.unwrapOptionField("partNumber", partNumber)
    def getExpectedBucketOwner: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("expectedBucketOwner", expectedBucketOwner)
    def getChecksumMode: ZIO[Any, AwsError, zio.aws.s3.model.ChecksumMode] =
      AwsError.unwrapOptionField("checksumMode", checksumMode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.GetObjectRequest
  ) extends zio.aws.s3.model.GetObjectRequest.ReadOnly {
    override val bucket: BucketName =
      zio.aws.s3.model.primitives.BucketName(impl.bucket())
    override val ifMatch: Optional[IfMatch] = zio.aws.core.internal
      .optionalFromNullable(impl.ifMatch())
      .map(value => zio.aws.s3.model.primitives.IfMatch(value))
    override val ifModifiedSince: Optional[IfModifiedSince] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ifModifiedSince())
        .map(value => zio.aws.s3.model.primitives.IfModifiedSince(value))
    override val ifNoneMatch: Optional[IfNoneMatch] = zio.aws.core.internal
      .optionalFromNullable(impl.ifNoneMatch())
      .map(value => zio.aws.s3.model.primitives.IfNoneMatch(value))
    override val ifUnmodifiedSince: Optional[IfUnmodifiedSince] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ifUnmodifiedSince())
        .map(value => zio.aws.s3.model.primitives.IfUnmodifiedSince(value))
    override val key: ObjectKey =
      zio.aws.s3.model.primitives.ObjectKey(impl.key())
    override val range: Optional[zio.aws.s3.model.primitives.Range] =
      zio.aws.core.internal
        .optionalFromNullable(impl.range())
        .map(value => zio.aws.s3.model.primitives.Range(value))
    override val responseCacheControl: Optional[ResponseCacheControl] =
      zio.aws.core.internal
        .optionalFromNullable(impl.responseCacheControl())
        .map(value => zio.aws.s3.model.primitives.ResponseCacheControl(value))
    override val responseContentDisposition
        : Optional[ResponseContentDisposition] = zio.aws.core.internal
      .optionalFromNullable(impl.responseContentDisposition())
      .map(value =>
        zio.aws.s3.model.primitives.ResponseContentDisposition(value)
      )
    override val responseContentEncoding: Optional[ResponseContentEncoding] =
      zio.aws.core.internal
        .optionalFromNullable(impl.responseContentEncoding())
        .map(value =>
          zio.aws.s3.model.primitives.ResponseContentEncoding(value)
        )
    override val responseContentLanguage: Optional[ResponseContentLanguage] =
      zio.aws.core.internal
        .optionalFromNullable(impl.responseContentLanguage())
        .map(value =>
          zio.aws.s3.model.primitives.ResponseContentLanguage(value)
        )
    override val responseContentType: Optional[ResponseContentType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.responseContentType())
        .map(value => zio.aws.s3.model.primitives.ResponseContentType(value))
    override val responseExpires: Optional[ResponseExpires] =
      zio.aws.core.internal
        .optionalFromNullable(impl.responseExpires())
        .map(value => zio.aws.s3.model.primitives.ResponseExpires(value))
    override val versionId: Optional[ObjectVersionId] = zio.aws.core.internal
      .optionalFromNullable(impl.versionId())
      .map(value => zio.aws.s3.model.primitives.ObjectVersionId(value))
    override val sseCustomerAlgorithm: Optional[SSECustomerAlgorithm] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sseCustomerAlgorithm())
        .map(value => zio.aws.s3.model.primitives.SSECustomerAlgorithm(value))
    override val sseCustomerKey: Optional[SSECustomerKey] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sseCustomerKey())
        .map(value => zio.aws.s3.model.primitives.SSECustomerKey(value))
    override val sseCustomerKeyMD5: Optional[SSECustomerKeyMD5] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sseCustomerKeyMD5())
        .map(value => zio.aws.s3.model.primitives.SSECustomerKeyMD5(value))
    override val requestPayer: Optional[zio.aws.s3.model.RequestPayer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.requestPayer())
        .map(value => zio.aws.s3.model.RequestPayer.wrap(value))
    override val partNumber: Optional[PartNumber] = zio.aws.core.internal
      .optionalFromNullable(impl.partNumber())
      .map(value => zio.aws.s3.model.primitives.PartNumber(value))
    override val expectedBucketOwner: Optional[AccountId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.expectedBucketOwner())
        .map(value => zio.aws.s3.model.primitives.AccountId(value))
    override val checksumMode: Optional[zio.aws.s3.model.ChecksumMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.checksumMode())
        .map(value => zio.aws.s3.model.ChecksumMode.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.GetObjectRequest
  ): zio.aws.s3.model.GetObjectRequest.ReadOnly = new Wrapper(impl)
}
