package zio.aws.s3.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetObjectRetentionResponse(
    retention: Optional[zio.aws.s3.model.ObjectLockRetention] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.GetObjectRetentionResponse = {
    import GetObjectRetentionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.GetObjectRetentionResponse
      .builder()
      .optionallyWith(retention.map(value => value.buildAwsValue()))(
        _.retention
      )
      .build()
  }
  def asReadOnly: zio.aws.s3.model.GetObjectRetentionResponse.ReadOnly =
    zio.aws.s3.model.GetObjectRetentionResponse.wrap(buildAwsValue())
}
object GetObjectRetentionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.GetObjectRetentionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.GetObjectRetentionResponse =
      zio.aws.s3.model
        .GetObjectRetentionResponse(retention.map(value => value.asEditable))
    def retention: Optional[zio.aws.s3.model.ObjectLockRetention.ReadOnly]
    def getRetention
        : ZIO[Any, AwsError, zio.aws.s3.model.ObjectLockRetention.ReadOnly] =
      AwsError.unwrapOptionField("retention", retention)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.GetObjectRetentionResponse
  ) extends zio.aws.s3.model.GetObjectRetentionResponse.ReadOnly {
    override val retention
        : Optional[zio.aws.s3.model.ObjectLockRetention.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.retention())
        .map(value => zio.aws.s3.model.ObjectLockRetention.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.GetObjectRetentionResponse
  ): zio.aws.s3.model.GetObjectRetentionResponse.ReadOnly = new Wrapper(impl)
}
