package zio.aws.s3.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.s3.model.primitives.{
  SSECustomerKey,
  AccountId,
  SSECustomerAlgorithm,
  IfModifiedSince,
  IfNoneMatch,
  IfMatch,
  SSECustomerKeyMD5,
  ObjectKey,
  BucketName,
  IfUnmodifiedSince,
  ObjectVersionId,
  PartNumber
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class HeadObjectRequest(
    bucket: BucketName,
    ifMatch: Optional[IfMatch] = Optional.Absent,
    ifModifiedSince: Optional[IfModifiedSince] = Optional.Absent,
    ifNoneMatch: Optional[IfNoneMatch] = Optional.Absent,
    ifUnmodifiedSince: Optional[IfUnmodifiedSince] = Optional.Absent,
    key: ObjectKey,
    range: Optional[zio.aws.s3.model.primitives.Range] = Optional.Absent,
    versionId: Optional[ObjectVersionId] = Optional.Absent,
    sseCustomerAlgorithm: Optional[SSECustomerAlgorithm] = Optional.Absent,
    sseCustomerKey: Optional[SSECustomerKey] = Optional.Absent,
    sseCustomerKeyMD5: Optional[SSECustomerKeyMD5] = Optional.Absent,
    requestPayer: Optional[zio.aws.s3.model.RequestPayer] = Optional.Absent,
    partNumber: Optional[PartNumber] = Optional.Absent,
    expectedBucketOwner: Optional[AccountId] = Optional.Absent,
    checksumMode: Optional[zio.aws.s3.model.ChecksumMode] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.HeadObjectRequest = {
    import HeadObjectRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.HeadObjectRequest
      .builder()
      .bucket(BucketName.unwrap(bucket): java.lang.String)
      .optionallyWith(
        ifMatch.map(value => IfMatch.unwrap(value): java.lang.String)
      )(_.ifMatch)
      .optionallyWith(
        ifModifiedSince.map(value => IfModifiedSince.unwrap(value): Instant)
      )(_.ifModifiedSince)
      .optionallyWith(
        ifNoneMatch.map(value => IfNoneMatch.unwrap(value): java.lang.String)
      )(_.ifNoneMatch)
      .optionallyWith(
        ifUnmodifiedSince.map(value => IfUnmodifiedSince.unwrap(value): Instant)
      )(_.ifUnmodifiedSince)
      .key(ObjectKey.unwrap(key): java.lang.String)
      .optionallyWith(
        range.map(value =>
          zio.aws.s3.model.primitives.Range.unwrap(value): java.lang.String
        )
      )(_.range)
      .optionallyWith(
        versionId.map(value => ObjectVersionId.unwrap(value): java.lang.String)
      )(_.versionId)
      .optionallyWith(
        sseCustomerAlgorithm.map(value =>
          SSECustomerAlgorithm.unwrap(value): java.lang.String
        )
      )(_.sseCustomerAlgorithm)
      .optionallyWith(
        sseCustomerKey.map(value =>
          SSECustomerKey.unwrap(value): java.lang.String
        )
      )(_.sseCustomerKey)
      .optionallyWith(
        sseCustomerKeyMD5.map(value =>
          SSECustomerKeyMD5.unwrap(value): java.lang.String
        )
      )(_.sseCustomerKeyMD5)
      .optionallyWith(requestPayer.map(value => value.unwrap))(_.requestPayer)
      .optionallyWith(
        partNumber.map(value => PartNumber.unwrap(value): Integer)
      )(_.partNumber)
      .optionallyWith(
        expectedBucketOwner.map(value =>
          AccountId.unwrap(value): java.lang.String
        )
      )(_.expectedBucketOwner)
      .optionallyWith(checksumMode.map(value => value.unwrap))(_.checksumMode)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.HeadObjectRequest.ReadOnly =
    zio.aws.s3.model.HeadObjectRequest.wrap(buildAwsValue())
}
object HeadObjectRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.HeadObjectRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.HeadObjectRequest =
      zio.aws.s3.model.HeadObjectRequest(
        bucket,
        ifMatch.map(value => value),
        ifModifiedSince.map(value => value),
        ifNoneMatch.map(value => value),
        ifUnmodifiedSince.map(value => value),
        key,
        range.map(value => value),
        versionId.map(value => value),
        sseCustomerAlgorithm.map(value => value),
        sseCustomerKey.map(value => value),
        sseCustomerKeyMD5.map(value => value),
        requestPayer.map(value => value),
        partNumber.map(value => value),
        expectedBucketOwner.map(value => value),
        checksumMode.map(value => value)
      )
    def bucket: BucketName
    def ifMatch: Optional[IfMatch]
    def ifModifiedSince: Optional[IfModifiedSince]
    def ifNoneMatch: Optional[IfNoneMatch]
    def ifUnmodifiedSince: Optional[IfUnmodifiedSince]
    def key: ObjectKey
    def range: Optional[zio.aws.s3.model.primitives.Range]
    def versionId: Optional[ObjectVersionId]
    def sseCustomerAlgorithm: Optional[SSECustomerAlgorithm]
    def sseCustomerKey: Optional[SSECustomerKey]
    def sseCustomerKeyMD5: Optional[SSECustomerKeyMD5]
    def requestPayer: Optional[zio.aws.s3.model.RequestPayer]
    def partNumber: Optional[PartNumber]
    def expectedBucketOwner: Optional[AccountId]
    def checksumMode: Optional[zio.aws.s3.model.ChecksumMode]
    def getBucket: ZIO[Any, Nothing, BucketName] = ZIO.succeed(bucket)
    def getIfMatch: ZIO[Any, AwsError, IfMatch] =
      AwsError.unwrapOptionField("ifMatch", ifMatch)
    def getIfModifiedSince: ZIO[Any, AwsError, IfModifiedSince] =
      AwsError.unwrapOptionField("ifModifiedSince", ifModifiedSince)
    def getIfNoneMatch: ZIO[Any, AwsError, IfNoneMatch] =
      AwsError.unwrapOptionField("ifNoneMatch", ifNoneMatch)
    def getIfUnmodifiedSince: ZIO[Any, AwsError, IfUnmodifiedSince] =
      AwsError.unwrapOptionField("ifUnmodifiedSince", ifUnmodifiedSince)
    def getKey: ZIO[Any, Nothing, ObjectKey] = ZIO.succeed(key)
    def getRange: ZIO[Any, AwsError, zio.aws.s3.model.primitives.Range] =
      AwsError.unwrapOptionField("range", range)
    def getVersionId: ZIO[Any, AwsError, ObjectVersionId] =
      AwsError.unwrapOptionField("versionId", versionId)
    def getSseCustomerAlgorithm: ZIO[Any, AwsError, SSECustomerAlgorithm] =
      AwsError.unwrapOptionField("sseCustomerAlgorithm", sseCustomerAlgorithm)
    def getSseCustomerKey: ZIO[Any, AwsError, SSECustomerKey] =
      AwsError.unwrapOptionField("sseCustomerKey", sseCustomerKey)
    def getSseCustomerKeyMD5: ZIO[Any, AwsError, SSECustomerKeyMD5] =
      AwsError.unwrapOptionField("sseCustomerKeyMD5", sseCustomerKeyMD5)
    def getRequestPayer: ZIO[Any, AwsError, zio.aws.s3.model.RequestPayer] =
      AwsError.unwrapOptionField("requestPayer", requestPayer)
    def getPartNumber: ZIO[Any, AwsError, PartNumber] =
      AwsError.unwrapOptionField("partNumber", partNumber)
    def getExpectedBucketOwner: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("expectedBucketOwner", expectedBucketOwner)
    def getChecksumMode: ZIO[Any, AwsError, zio.aws.s3.model.ChecksumMode] =
      AwsError.unwrapOptionField("checksumMode", checksumMode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.HeadObjectRequest
  ) extends zio.aws.s3.model.HeadObjectRequest.ReadOnly {
    override val bucket: BucketName =
      zio.aws.s3.model.primitives.BucketName(impl.bucket())
    override val ifMatch: Optional[IfMatch] = zio.aws.core.internal
      .optionalFromNullable(impl.ifMatch())
      .map(value => zio.aws.s3.model.primitives.IfMatch(value))
    override val ifModifiedSince: Optional[IfModifiedSince] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ifModifiedSince())
        .map(value => zio.aws.s3.model.primitives.IfModifiedSince(value))
    override val ifNoneMatch: Optional[IfNoneMatch] = zio.aws.core.internal
      .optionalFromNullable(impl.ifNoneMatch())
      .map(value => zio.aws.s3.model.primitives.IfNoneMatch(value))
    override val ifUnmodifiedSince: Optional[IfUnmodifiedSince] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ifUnmodifiedSince())
        .map(value => zio.aws.s3.model.primitives.IfUnmodifiedSince(value))
    override val key: ObjectKey =
      zio.aws.s3.model.primitives.ObjectKey(impl.key())
    override val range: Optional[zio.aws.s3.model.primitives.Range] =
      zio.aws.core.internal
        .optionalFromNullable(impl.range())
        .map(value => zio.aws.s3.model.primitives.Range(value))
    override val versionId: Optional[ObjectVersionId] = zio.aws.core.internal
      .optionalFromNullable(impl.versionId())
      .map(value => zio.aws.s3.model.primitives.ObjectVersionId(value))
    override val sseCustomerAlgorithm: Optional[SSECustomerAlgorithm] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sseCustomerAlgorithm())
        .map(value => zio.aws.s3.model.primitives.SSECustomerAlgorithm(value))
    override val sseCustomerKey: Optional[SSECustomerKey] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sseCustomerKey())
        .map(value => zio.aws.s3.model.primitives.SSECustomerKey(value))
    override val sseCustomerKeyMD5: Optional[SSECustomerKeyMD5] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sseCustomerKeyMD5())
        .map(value => zio.aws.s3.model.primitives.SSECustomerKeyMD5(value))
    override val requestPayer: Optional[zio.aws.s3.model.RequestPayer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.requestPayer())
        .map(value => zio.aws.s3.model.RequestPayer.wrap(value))
    override val partNumber: Optional[PartNumber] = zio.aws.core.internal
      .optionalFromNullable(impl.partNumber())
      .map(value => zio.aws.s3.model.primitives.PartNumber(value))
    override val expectedBucketOwner: Optional[AccountId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.expectedBucketOwner())
        .map(value => zio.aws.s3.model.primitives.AccountId(value))
    override val checksumMode: Optional[zio.aws.s3.model.ChecksumMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.checksumMode())
        .map(value => zio.aws.s3.model.ChecksumMode.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.HeadObjectRequest
  ): zio.aws.s3.model.HeadObjectRequest.ReadOnly = new Wrapper(impl)
}
