package zio.aws.s3.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.s3.model.primitives.{
  ContentType,
  ETag,
  CacheControl,
  WebsiteRedirectLocation,
  AcceptRanges,
  ContentDisposition,
  ContentLanguage,
  Expiration,
  ContentLength,
  PartsCount,
  SSECustomerAlgorithm,
  SSECustomerKeyMD5,
  DeleteMarker,
  ChecksumSHA256,
  LastModified,
  Expires,
  ContentEncoding,
  ChecksumCRC32C,
  ChecksumCRC32,
  MissingMeta,
  ChecksumSHA1,
  SSEKMSKeyId,
  MetadataValue,
  ObjectLockRetainUntilDate,
  Restore,
  ObjectVersionId,
  MetadataKey,
  BucketKeyEnabled
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class HeadObjectResponse(
    deleteMarker: Optional[DeleteMarker] = Optional.Absent,
    acceptRanges: Optional[AcceptRanges] = Optional.Absent,
    expiration: Optional[Expiration] = Optional.Absent,
    restore: Optional[Restore] = Optional.Absent,
    archiveStatus: Optional[zio.aws.s3.model.ArchiveStatus] = Optional.Absent,
    lastModified: Optional[LastModified] = Optional.Absent,
    contentLength: Optional[ContentLength] = Optional.Absent,
    checksumCRC32: Optional[ChecksumCRC32] = Optional.Absent,
    checksumCRC32C: Optional[ChecksumCRC32C] = Optional.Absent,
    checksumSHA1: Optional[ChecksumSHA1] = Optional.Absent,
    checksumSHA256: Optional[ChecksumSHA256] = Optional.Absent,
    eTag: Optional[ETag] = Optional.Absent,
    missingMeta: Optional[MissingMeta] = Optional.Absent,
    versionId: Optional[ObjectVersionId] = Optional.Absent,
    cacheControl: Optional[CacheControl] = Optional.Absent,
    contentDisposition: Optional[ContentDisposition] = Optional.Absent,
    contentEncoding: Optional[ContentEncoding] = Optional.Absent,
    contentLanguage: Optional[ContentLanguage] = Optional.Absent,
    contentType: Optional[ContentType] = Optional.Absent,
    expires: Optional[Expires] = Optional.Absent,
    websiteRedirectLocation: Optional[WebsiteRedirectLocation] =
      Optional.Absent,
    serverSideEncryption: Optional[zio.aws.s3.model.ServerSideEncryption] =
      Optional.Absent,
    metadata: Optional[Map[MetadataKey, MetadataValue]] = Optional.Absent,
    sseCustomerAlgorithm: Optional[SSECustomerAlgorithm] = Optional.Absent,
    sseCustomerKeyMD5: Optional[SSECustomerKeyMD5] = Optional.Absent,
    ssekmsKeyId: Optional[SSEKMSKeyId] = Optional.Absent,
    bucketKeyEnabled: Optional[BucketKeyEnabled] = Optional.Absent,
    storageClass: Optional[zio.aws.s3.model.StorageClass] = Optional.Absent,
    requestCharged: Optional[zio.aws.s3.model.RequestCharged] = Optional.Absent,
    replicationStatus: Optional[zio.aws.s3.model.ReplicationStatus] =
      Optional.Absent,
    partsCount: Optional[PartsCount] = Optional.Absent,
    objectLockMode: Optional[zio.aws.s3.model.ObjectLockMode] = Optional.Absent,
    objectLockRetainUntilDate: Optional[ObjectLockRetainUntilDate] =
      Optional.Absent,
    objectLockLegalHoldStatus: Optional[
      zio.aws.s3.model.ObjectLockLegalHoldStatus
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.HeadObjectResponse = {
    import HeadObjectResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.HeadObjectResponse
      .builder()
      .optionallyWith(
        deleteMarker.map(value => DeleteMarker.unwrap(value): java.lang.Boolean)
      )(_.deleteMarker)
      .optionallyWith(
        acceptRanges.map(value => AcceptRanges.unwrap(value): java.lang.String)
      )(_.acceptRanges)
      .optionallyWith(
        expiration.map(value => Expiration.unwrap(value): java.lang.String)
      )(_.expiration)
      .optionallyWith(
        restore.map(value => Restore.unwrap(value): java.lang.String)
      )(_.restore)
      .optionallyWith(archiveStatus.map(value => value.unwrap))(_.archiveStatus)
      .optionallyWith(
        lastModified.map(value => LastModified.unwrap(value): Instant)
      )(_.lastModified)
      .optionallyWith(
        contentLength.map(value => ContentLength.unwrap(value): java.lang.Long)
      )(_.contentLength)
      .optionallyWith(
        checksumCRC32.map(value =>
          ChecksumCRC32.unwrap(value): java.lang.String
        )
      )(_.checksumCRC32)
      .optionallyWith(
        checksumCRC32C.map(value =>
          ChecksumCRC32C.unwrap(value): java.lang.String
        )
      )(_.checksumCRC32C)
      .optionallyWith(
        checksumSHA1.map(value => ChecksumSHA1.unwrap(value): java.lang.String)
      )(_.checksumSHA1)
      .optionallyWith(
        checksumSHA256.map(value =>
          ChecksumSHA256.unwrap(value): java.lang.String
        )
      )(_.checksumSHA256)
      .optionallyWith(eTag.map(value => ETag.unwrap(value): java.lang.String))(
        _.eTag
      )
      .optionallyWith(
        missingMeta.map(value => MissingMeta.unwrap(value): Integer)
      )(_.missingMeta)
      .optionallyWith(
        versionId.map(value => ObjectVersionId.unwrap(value): java.lang.String)
      )(_.versionId)
      .optionallyWith(
        cacheControl.map(value => CacheControl.unwrap(value): java.lang.String)
      )(_.cacheControl)
      .optionallyWith(
        contentDisposition.map(value =>
          ContentDisposition.unwrap(value): java.lang.String
        )
      )(_.contentDisposition)
      .optionallyWith(
        contentEncoding.map(value =>
          ContentEncoding.unwrap(value): java.lang.String
        )
      )(_.contentEncoding)
      .optionallyWith(
        contentLanguage.map(value =>
          ContentLanguage.unwrap(value): java.lang.String
        )
      )(_.contentLanguage)
      .optionallyWith(
        contentType.map(value => ContentType.unwrap(value): java.lang.String)
      )(_.contentType)
      .optionallyWith(expires.map(value => Expires.unwrap(value): Instant))(
        _.expires
      )
      .optionallyWith(
        websiteRedirectLocation.map(value =>
          WebsiteRedirectLocation.unwrap(value): java.lang.String
        )
      )(_.websiteRedirectLocation)
      .optionallyWith(serverSideEncryption.map(value => value.unwrap))(
        _.serverSideEncryption
      )
      .optionallyWith(
        metadata.map(value =>
          value
            .map({ case (key, value) =>
              (MetadataKey.unwrap(key): java.lang.String) -> (MetadataValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.metadata)
      .optionallyWith(
        sseCustomerAlgorithm.map(value =>
          SSECustomerAlgorithm.unwrap(value): java.lang.String
        )
      )(_.sseCustomerAlgorithm)
      .optionallyWith(
        sseCustomerKeyMD5.map(value =>
          SSECustomerKeyMD5.unwrap(value): java.lang.String
        )
      )(_.sseCustomerKeyMD5)
      .optionallyWith(
        ssekmsKeyId.map(value => SSEKMSKeyId.unwrap(value): java.lang.String)
      )(_.ssekmsKeyId)
      .optionallyWith(
        bucketKeyEnabled.map(value =>
          BucketKeyEnabled.unwrap(value): java.lang.Boolean
        )
      )(_.bucketKeyEnabled)
      .optionallyWith(storageClass.map(value => value.unwrap))(_.storageClass)
      .optionallyWith(requestCharged.map(value => value.unwrap))(
        _.requestCharged
      )
      .optionallyWith(replicationStatus.map(value => value.unwrap))(
        _.replicationStatus
      )
      .optionallyWith(
        partsCount.map(value => PartsCount.unwrap(value): Integer)
      )(_.partsCount)
      .optionallyWith(objectLockMode.map(value => value.unwrap))(
        _.objectLockMode
      )
      .optionallyWith(
        objectLockRetainUntilDate.map(value =>
          ObjectLockRetainUntilDate.unwrap(value): Instant
        )
      )(_.objectLockRetainUntilDate)
      .optionallyWith(objectLockLegalHoldStatus.map(value => value.unwrap))(
        _.objectLockLegalHoldStatus
      )
      .build()
  }
  def asReadOnly: zio.aws.s3.model.HeadObjectResponse.ReadOnly =
    zio.aws.s3.model.HeadObjectResponse.wrap(buildAwsValue())
}
object HeadObjectResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.HeadObjectResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.HeadObjectResponse =
      zio.aws.s3.model.HeadObjectResponse(
        deleteMarker.map(value => value),
        acceptRanges.map(value => value),
        expiration.map(value => value),
        restore.map(value => value),
        archiveStatus.map(value => value),
        lastModified.map(value => value),
        contentLength.map(value => value),
        checksumCRC32.map(value => value),
        checksumCRC32C.map(value => value),
        checksumSHA1.map(value => value),
        checksumSHA256.map(value => value),
        eTag.map(value => value),
        missingMeta.map(value => value),
        versionId.map(value => value),
        cacheControl.map(value => value),
        contentDisposition.map(value => value),
        contentEncoding.map(value => value),
        contentLanguage.map(value => value),
        contentType.map(value => value),
        expires.map(value => value),
        websiteRedirectLocation.map(value => value),
        serverSideEncryption.map(value => value),
        metadata.map(value => value),
        sseCustomerAlgorithm.map(value => value),
        sseCustomerKeyMD5.map(value => value),
        ssekmsKeyId.map(value => value),
        bucketKeyEnabled.map(value => value),
        storageClass.map(value => value),
        requestCharged.map(value => value),
        replicationStatus.map(value => value),
        partsCount.map(value => value),
        objectLockMode.map(value => value),
        objectLockRetainUntilDate.map(value => value),
        objectLockLegalHoldStatus.map(value => value)
      )
    def deleteMarker: Optional[DeleteMarker]
    def acceptRanges: Optional[AcceptRanges]
    def expiration: Optional[Expiration]
    def restore: Optional[Restore]
    def archiveStatus: Optional[zio.aws.s3.model.ArchiveStatus]
    def lastModified: Optional[LastModified]
    def contentLength: Optional[ContentLength]
    def checksumCRC32: Optional[ChecksumCRC32]
    def checksumCRC32C: Optional[ChecksumCRC32C]
    def checksumSHA1: Optional[ChecksumSHA1]
    def checksumSHA256: Optional[ChecksumSHA256]
    def eTag: Optional[ETag]
    def missingMeta: Optional[MissingMeta]
    def versionId: Optional[ObjectVersionId]
    def cacheControl: Optional[CacheControl]
    def contentDisposition: Optional[ContentDisposition]
    def contentEncoding: Optional[ContentEncoding]
    def contentLanguage: Optional[ContentLanguage]
    def contentType: Optional[ContentType]
    def expires: Optional[Expires]
    def websiteRedirectLocation: Optional[WebsiteRedirectLocation]
    def serverSideEncryption: Optional[zio.aws.s3.model.ServerSideEncryption]
    def metadata: Optional[Map[MetadataKey, MetadataValue]]
    def sseCustomerAlgorithm: Optional[SSECustomerAlgorithm]
    def sseCustomerKeyMD5: Optional[SSECustomerKeyMD5]
    def ssekmsKeyId: Optional[SSEKMSKeyId]
    def bucketKeyEnabled: Optional[BucketKeyEnabled]
    def storageClass: Optional[zio.aws.s3.model.StorageClass]
    def requestCharged: Optional[zio.aws.s3.model.RequestCharged]
    def replicationStatus: Optional[zio.aws.s3.model.ReplicationStatus]
    def partsCount: Optional[PartsCount]
    def objectLockMode: Optional[zio.aws.s3.model.ObjectLockMode]
    def objectLockRetainUntilDate: Optional[ObjectLockRetainUntilDate]
    def objectLockLegalHoldStatus
        : Optional[zio.aws.s3.model.ObjectLockLegalHoldStatus]
    def getDeleteMarker: ZIO[Any, AwsError, DeleteMarker] =
      AwsError.unwrapOptionField("deleteMarker", deleteMarker)
    def getAcceptRanges: ZIO[Any, AwsError, AcceptRanges] =
      AwsError.unwrapOptionField("acceptRanges", acceptRanges)
    def getExpiration: ZIO[Any, AwsError, Expiration] =
      AwsError.unwrapOptionField("expiration", expiration)
    def getRestore: ZIO[Any, AwsError, Restore] =
      AwsError.unwrapOptionField("restore", restore)
    def getArchiveStatus: ZIO[Any, AwsError, zio.aws.s3.model.ArchiveStatus] =
      AwsError.unwrapOptionField("archiveStatus", archiveStatus)
    def getLastModified: ZIO[Any, AwsError, LastModified] =
      AwsError.unwrapOptionField("lastModified", lastModified)
    def getContentLength: ZIO[Any, AwsError, ContentLength] =
      AwsError.unwrapOptionField("contentLength", contentLength)
    def getChecksumCRC32: ZIO[Any, AwsError, ChecksumCRC32] =
      AwsError.unwrapOptionField("checksumCRC32", checksumCRC32)
    def getChecksumCRC32C: ZIO[Any, AwsError, ChecksumCRC32C] =
      AwsError.unwrapOptionField("checksumCRC32C", checksumCRC32C)
    def getChecksumSHA1: ZIO[Any, AwsError, ChecksumSHA1] =
      AwsError.unwrapOptionField("checksumSHA1", checksumSHA1)
    def getChecksumSHA256: ZIO[Any, AwsError, ChecksumSHA256] =
      AwsError.unwrapOptionField("checksumSHA256", checksumSHA256)
    def getETag: ZIO[Any, AwsError, ETag] =
      AwsError.unwrapOptionField("eTag", eTag)
    def getMissingMeta: ZIO[Any, AwsError, MissingMeta] =
      AwsError.unwrapOptionField("missingMeta", missingMeta)
    def getVersionId: ZIO[Any, AwsError, ObjectVersionId] =
      AwsError.unwrapOptionField("versionId", versionId)
    def getCacheControl: ZIO[Any, AwsError, CacheControl] =
      AwsError.unwrapOptionField("cacheControl", cacheControl)
    def getContentDisposition: ZIO[Any, AwsError, ContentDisposition] =
      AwsError.unwrapOptionField("contentDisposition", contentDisposition)
    def getContentEncoding: ZIO[Any, AwsError, ContentEncoding] =
      AwsError.unwrapOptionField("contentEncoding", contentEncoding)
    def getContentLanguage: ZIO[Any, AwsError, ContentLanguage] =
      AwsError.unwrapOptionField("contentLanguage", contentLanguage)
    def getContentType: ZIO[Any, AwsError, ContentType] =
      AwsError.unwrapOptionField("contentType", contentType)
    def getExpires: ZIO[Any, AwsError, Expires] =
      AwsError.unwrapOptionField("expires", expires)
    def getWebsiteRedirectLocation
        : ZIO[Any, AwsError, WebsiteRedirectLocation] = AwsError
      .unwrapOptionField("websiteRedirectLocation", websiteRedirectLocation)
    def getServerSideEncryption
        : ZIO[Any, AwsError, zio.aws.s3.model.ServerSideEncryption] =
      AwsError.unwrapOptionField("serverSideEncryption", serverSideEncryption)
    def getMetadata: ZIO[Any, AwsError, Map[MetadataKey, MetadataValue]] =
      AwsError.unwrapOptionField("metadata", metadata)
    def getSseCustomerAlgorithm: ZIO[Any, AwsError, SSECustomerAlgorithm] =
      AwsError.unwrapOptionField("sseCustomerAlgorithm", sseCustomerAlgorithm)
    def getSseCustomerKeyMD5: ZIO[Any, AwsError, SSECustomerKeyMD5] =
      AwsError.unwrapOptionField("sseCustomerKeyMD5", sseCustomerKeyMD5)
    def getSsekmsKeyId: ZIO[Any, AwsError, SSEKMSKeyId] =
      AwsError.unwrapOptionField("ssekmsKeyId", ssekmsKeyId)
    def getBucketKeyEnabled: ZIO[Any, AwsError, BucketKeyEnabled] =
      AwsError.unwrapOptionField("bucketKeyEnabled", bucketKeyEnabled)
    def getStorageClass: ZIO[Any, AwsError, zio.aws.s3.model.StorageClass] =
      AwsError.unwrapOptionField("storageClass", storageClass)
    def getRequestCharged: ZIO[Any, AwsError, zio.aws.s3.model.RequestCharged] =
      AwsError.unwrapOptionField("requestCharged", requestCharged)
    def getReplicationStatus
        : ZIO[Any, AwsError, zio.aws.s3.model.ReplicationStatus] =
      AwsError.unwrapOptionField("replicationStatus", replicationStatus)
    def getPartsCount: ZIO[Any, AwsError, PartsCount] =
      AwsError.unwrapOptionField("partsCount", partsCount)
    def getObjectLockMode: ZIO[Any, AwsError, zio.aws.s3.model.ObjectLockMode] =
      AwsError.unwrapOptionField("objectLockMode", objectLockMode)
    def getObjectLockRetainUntilDate
        : ZIO[Any, AwsError, ObjectLockRetainUntilDate] = AwsError
      .unwrapOptionField("objectLockRetainUntilDate", objectLockRetainUntilDate)
    def getObjectLockLegalHoldStatus
        : ZIO[Any, AwsError, zio.aws.s3.model.ObjectLockLegalHoldStatus] =
      AwsError.unwrapOptionField(
        "objectLockLegalHoldStatus",
        objectLockLegalHoldStatus
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.HeadObjectResponse
  ) extends zio.aws.s3.model.HeadObjectResponse.ReadOnly {
    override val deleteMarker: Optional[DeleteMarker] = zio.aws.core.internal
      .optionalFromNullable(impl.deleteMarker())
      .map(value => zio.aws.s3.model.primitives.DeleteMarker(value))
    override val acceptRanges: Optional[AcceptRanges] = zio.aws.core.internal
      .optionalFromNullable(impl.acceptRanges())
      .map(value => zio.aws.s3.model.primitives.AcceptRanges(value))
    override val expiration: Optional[Expiration] = zio.aws.core.internal
      .optionalFromNullable(impl.expiration())
      .map(value => zio.aws.s3.model.primitives.Expiration(value))
    override val restore: Optional[Restore] = zio.aws.core.internal
      .optionalFromNullable(impl.restore())
      .map(value => zio.aws.s3.model.primitives.Restore(value))
    override val archiveStatus: Optional[zio.aws.s3.model.ArchiveStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.archiveStatus())
        .map(value => zio.aws.s3.model.ArchiveStatus.wrap(value))
    override val lastModified: Optional[LastModified] = zio.aws.core.internal
      .optionalFromNullable(impl.lastModified())
      .map(value => zio.aws.s3.model.primitives.LastModified(value))
    override val contentLength: Optional[ContentLength] = zio.aws.core.internal
      .optionalFromNullable(impl.contentLength())
      .map(value => zio.aws.s3.model.primitives.ContentLength(value))
    override val checksumCRC32: Optional[ChecksumCRC32] = zio.aws.core.internal
      .optionalFromNullable(impl.checksumCRC32())
      .map(value => zio.aws.s3.model.primitives.ChecksumCRC32(value))
    override val checksumCRC32C: Optional[ChecksumCRC32C] =
      zio.aws.core.internal
        .optionalFromNullable(impl.checksumCRC32C())
        .map(value => zio.aws.s3.model.primitives.ChecksumCRC32C(value))
    override val checksumSHA1: Optional[ChecksumSHA1] = zio.aws.core.internal
      .optionalFromNullable(impl.checksumSHA1())
      .map(value => zio.aws.s3.model.primitives.ChecksumSHA1(value))
    override val checksumSHA256: Optional[ChecksumSHA256] =
      zio.aws.core.internal
        .optionalFromNullable(impl.checksumSHA256())
        .map(value => zio.aws.s3.model.primitives.ChecksumSHA256(value))
    override val eTag: Optional[ETag] = zio.aws.core.internal
      .optionalFromNullable(impl.eTag())
      .map(value => zio.aws.s3.model.primitives.ETag(value))
    override val missingMeta: Optional[MissingMeta] = zio.aws.core.internal
      .optionalFromNullable(impl.missingMeta())
      .map(value => zio.aws.s3.model.primitives.MissingMeta(value))
    override val versionId: Optional[ObjectVersionId] = zio.aws.core.internal
      .optionalFromNullable(impl.versionId())
      .map(value => zio.aws.s3.model.primitives.ObjectVersionId(value))
    override val cacheControl: Optional[CacheControl] = zio.aws.core.internal
      .optionalFromNullable(impl.cacheControl())
      .map(value => zio.aws.s3.model.primitives.CacheControl(value))
    override val contentDisposition: Optional[ContentDisposition] =
      zio.aws.core.internal
        .optionalFromNullable(impl.contentDisposition())
        .map(value => zio.aws.s3.model.primitives.ContentDisposition(value))
    override val contentEncoding: Optional[ContentEncoding] =
      zio.aws.core.internal
        .optionalFromNullable(impl.contentEncoding())
        .map(value => zio.aws.s3.model.primitives.ContentEncoding(value))
    override val contentLanguage: Optional[ContentLanguage] =
      zio.aws.core.internal
        .optionalFromNullable(impl.contentLanguage())
        .map(value => zio.aws.s3.model.primitives.ContentLanguage(value))
    override val contentType: Optional[ContentType] = zio.aws.core.internal
      .optionalFromNullable(impl.contentType())
      .map(value => zio.aws.s3.model.primitives.ContentType(value))
    override val expires: Optional[Expires] = zio.aws.core.internal
      .optionalFromNullable(impl.expires())
      .map(value => zio.aws.s3.model.primitives.Expires(value))
    override val websiteRedirectLocation: Optional[WebsiteRedirectLocation] =
      zio.aws.core.internal
        .optionalFromNullable(impl.websiteRedirectLocation())
        .map(value =>
          zio.aws.s3.model.primitives.WebsiteRedirectLocation(value)
        )
    override val serverSideEncryption
        : Optional[zio.aws.s3.model.ServerSideEncryption] =
      zio.aws.core.internal
        .optionalFromNullable(impl.serverSideEncryption())
        .map(value => zio.aws.s3.model.ServerSideEncryption.wrap(value))
    override val metadata: Optional[Map[MetadataKey, MetadataValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.metadata())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.s3.model.primitives.MetadataKey(
                key
              ) -> zio.aws.s3.model.primitives.MetadataValue(value)
            })
            .toMap
        )
    override val sseCustomerAlgorithm: Optional[SSECustomerAlgorithm] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sseCustomerAlgorithm())
        .map(value => zio.aws.s3.model.primitives.SSECustomerAlgorithm(value))
    override val sseCustomerKeyMD5: Optional[SSECustomerKeyMD5] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sseCustomerKeyMD5())
        .map(value => zio.aws.s3.model.primitives.SSECustomerKeyMD5(value))
    override val ssekmsKeyId: Optional[SSEKMSKeyId] = zio.aws.core.internal
      .optionalFromNullable(impl.ssekmsKeyId())
      .map(value => zio.aws.s3.model.primitives.SSEKMSKeyId(value))
    override val bucketKeyEnabled: Optional[BucketKeyEnabled] =
      zio.aws.core.internal
        .optionalFromNullable(impl.bucketKeyEnabled())
        .map(value => zio.aws.s3.model.primitives.BucketKeyEnabled(value))
    override val storageClass: Optional[zio.aws.s3.model.StorageClass] =
      zio.aws.core.internal
        .optionalFromNullable(impl.storageClass())
        .map(value => zio.aws.s3.model.StorageClass.wrap(value))
    override val requestCharged: Optional[zio.aws.s3.model.RequestCharged] =
      zio.aws.core.internal
        .optionalFromNullable(impl.requestCharged())
        .map(value => zio.aws.s3.model.RequestCharged.wrap(value))
    override val replicationStatus
        : Optional[zio.aws.s3.model.ReplicationStatus] = zio.aws.core.internal
      .optionalFromNullable(impl.replicationStatus())
      .map(value => zio.aws.s3.model.ReplicationStatus.wrap(value))
    override val partsCount: Optional[PartsCount] = zio.aws.core.internal
      .optionalFromNullable(impl.partsCount())
      .map(value => zio.aws.s3.model.primitives.PartsCount(value))
    override val objectLockMode: Optional[zio.aws.s3.model.ObjectLockMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.objectLockMode())
        .map(value => zio.aws.s3.model.ObjectLockMode.wrap(value))
    override val objectLockRetainUntilDate
        : Optional[ObjectLockRetainUntilDate] = zio.aws.core.internal
      .optionalFromNullable(impl.objectLockRetainUntilDate())
      .map(value =>
        zio.aws.s3.model.primitives.ObjectLockRetainUntilDate(value)
      )
    override val objectLockLegalHoldStatus
        : Optional[zio.aws.s3.model.ObjectLockLegalHoldStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.objectLockLegalHoldStatus())
        .map(value => zio.aws.s3.model.ObjectLockLegalHoldStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.HeadObjectResponse
  ): zio.aws.s3.model.HeadObjectResponse.ReadOnly = new Wrapper(impl)
}
