package zio.aws.s3.model
import zio.aws.s3.model.primitives.{DisplayName, ID}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class Initiator(
    id: Optional[ID] = Optional.Absent,
    displayName: Optional[DisplayName] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.s3.model.Initiator = {
    import Initiator.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.Initiator
      .builder()
      .optionallyWith(id.map(value => ID.unwrap(value): java.lang.String))(_.id)
      .optionallyWith(
        displayName.map(value => DisplayName.unwrap(value): java.lang.String)
      )(_.displayName)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.Initiator.ReadOnly =
    zio.aws.s3.model.Initiator.wrap(buildAwsValue())
}
object Initiator {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.s3.model.Initiator] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.Initiator = zio.aws.s3.model
      .Initiator(id.map(value => value), displayName.map(value => value))
    def id: Optional[ID]
    def displayName: Optional[DisplayName]
    def getId: ZIO[Any, AwsError, ID] = AwsError.unwrapOptionField("id", id)
    def getDisplayName: ZIO[Any, AwsError, DisplayName] =
      AwsError.unwrapOptionField("displayName", displayName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.Initiator
  ) extends zio.aws.s3.model.Initiator.ReadOnly {
    override val id: Optional[ID] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.s3.model.primitives.ID(value))
    override val displayName: Optional[DisplayName] = zio.aws.core.internal
      .optionalFromNullable(impl.displayName())
      .map(value => zio.aws.s3.model.primitives.DisplayName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.Initiator
  ): zio.aws.s3.model.Initiator.ReadOnly = new Wrapper(impl)
}
