package zio.aws.s3.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class InventorySchedule(
    frequency: zio.aws.s3.model.InventoryFrequency
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.InventorySchedule = {
    import InventorySchedule.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.InventorySchedule
      .builder()
      .frequency(frequency.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.InventorySchedule.ReadOnly =
    zio.aws.s3.model.InventorySchedule.wrap(buildAwsValue())
}
object InventorySchedule {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.InventorySchedule
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.InventorySchedule =
      zio.aws.s3.model.InventorySchedule(frequency)
    def frequency: zio.aws.s3.model.InventoryFrequency
    def getFrequency: ZIO[Any, Nothing, zio.aws.s3.model.InventoryFrequency] =
      ZIO.succeed(frequency)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.InventorySchedule
  ) extends zio.aws.s3.model.InventorySchedule.ReadOnly {
    override val frequency: zio.aws.s3.model.InventoryFrequency =
      zio.aws.s3.model.InventoryFrequency.wrap(impl.frequency())
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.InventorySchedule
  ): zio.aws.s3.model.InventorySchedule.ReadOnly = new Wrapper(impl)
}
