package zio.aws.s3.model
import zio.aws.s3.model.primitives.{LambdaFunctionArn, NotificationId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class LambdaFunctionConfiguration(
    id: Optional[NotificationId] = Optional.Absent,
    lambdaFunctionArn: LambdaFunctionArn,
    events: Iterable[zio.aws.s3.model.Event],
    filter: Optional[zio.aws.s3.model.NotificationConfigurationFilter] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.LambdaFunctionConfiguration = {
    import LambdaFunctionConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.LambdaFunctionConfiguration
      .builder()
      .optionallyWith(
        id.map(value => NotificationId.unwrap(value): java.lang.String)
      )(_.id)
      .lambdaFunctionArn(
        LambdaFunctionArn.unwrap(lambdaFunctionArn): java.lang.String
      )
      .eventsWithStrings(events.map { item =>
        item.unwrap.toString
      }.asJavaCollection)
      .optionallyWith(filter.map(value => value.buildAwsValue()))(_.filter)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.LambdaFunctionConfiguration.ReadOnly =
    zio.aws.s3.model.LambdaFunctionConfiguration.wrap(buildAwsValue())
}
object LambdaFunctionConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.LambdaFunctionConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.LambdaFunctionConfiguration =
      zio.aws.s3.model.LambdaFunctionConfiguration(
        id.map(value => value),
        lambdaFunctionArn,
        events,
        filter.map(value => value.asEditable)
      )
    def id: Optional[NotificationId]
    def lambdaFunctionArn: LambdaFunctionArn
    def events: List[zio.aws.s3.model.Event]
    def filter
        : Optional[zio.aws.s3.model.NotificationConfigurationFilter.ReadOnly]
    def getId: ZIO[Any, AwsError, NotificationId] =
      AwsError.unwrapOptionField("id", id)
    def getLambdaFunctionArn: ZIO[Any, Nothing, LambdaFunctionArn] =
      ZIO.succeed(lambdaFunctionArn)
    def getEvents: ZIO[Any, Nothing, List[zio.aws.s3.model.Event]] =
      ZIO.succeed(events)
    def getFilter: ZIO[
      Any,
      AwsError,
      zio.aws.s3.model.NotificationConfigurationFilter.ReadOnly
    ] = AwsError.unwrapOptionField("filter", filter)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.LambdaFunctionConfiguration
  ) extends zio.aws.s3.model.LambdaFunctionConfiguration.ReadOnly {
    override val id: Optional[NotificationId] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.s3.model.primitives.NotificationId(value))
    override val lambdaFunctionArn: LambdaFunctionArn =
      zio.aws.s3.model.primitives.LambdaFunctionArn(impl.lambdaFunctionArn())
    override val events: List[zio.aws.s3.model.Event] = impl
      .events()
      .asScala
      .map { item =>
        zio.aws.s3.model.Event.wrap(item)
      }
      .toList
    override val filter
        : Optional[zio.aws.s3.model.NotificationConfigurationFilter.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filter())
        .map(value =>
          zio.aws.s3.model.NotificationConfigurationFilter.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.LambdaFunctionConfiguration
  ): zio.aws.s3.model.LambdaFunctionConfiguration.ReadOnly = new Wrapper(impl)
}
