package zio.aws.s3.model
import zio.aws.s3.model.primitives.{Prefix, ID}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class LifecycleRule(
    expiration: Optional[zio.aws.s3.model.LifecycleExpiration] =
      Optional.Absent,
    id: Optional[ID] = Optional.Absent,
    prefix: Optional[Prefix] = Optional.Absent,
    filter: Optional[zio.aws.s3.model.LifecycleRuleFilter] = Optional.Absent,
    status: zio.aws.s3.model.ExpirationStatus,
    transitions: Optional[Iterable[zio.aws.s3.model.Transition]] =
      Optional.Absent,
    noncurrentVersionTransitions: Optional[
      Iterable[zio.aws.s3.model.NoncurrentVersionTransition]
    ] = Optional.Absent,
    noncurrentVersionExpiration: Optional[
      zio.aws.s3.model.NoncurrentVersionExpiration
    ] = Optional.Absent,
    abortIncompleteMultipartUpload: Optional[
      zio.aws.s3.model.AbortIncompleteMultipartUpload
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.LifecycleRule = {
    import LifecycleRule.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.LifecycleRule
      .builder()
      .optionallyWith(expiration.map(value => value.buildAwsValue()))(
        _.expiration
      )
      .optionallyWith(id.map(value => ID.unwrap(value): java.lang.String))(_.id)
      .optionallyWith(
        prefix.map(value => Prefix.unwrap(value): java.lang.String)
      )(_.prefix)
      .optionallyWith(filter.map(value => value.buildAwsValue()))(_.filter)
      .status(status.unwrap)
      .optionallyWith(
        transitions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.transitions)
      .optionallyWith(
        noncurrentVersionTransitions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.noncurrentVersionTransitions)
      .optionallyWith(
        noncurrentVersionExpiration.map(value => value.buildAwsValue())
      )(_.noncurrentVersionExpiration)
      .optionallyWith(
        abortIncompleteMultipartUpload.map(value => value.buildAwsValue())
      )(_.abortIncompleteMultipartUpload)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.LifecycleRule.ReadOnly =
    zio.aws.s3.model.LifecycleRule.wrap(buildAwsValue())
}
object LifecycleRule {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.s3.model.LifecycleRule] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.LifecycleRule =
      zio.aws.s3.model.LifecycleRule(
        expiration.map(value => value.asEditable),
        id.map(value => value),
        prefix.map(value => value),
        filter.map(value => value.asEditable),
        status,
        transitions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        noncurrentVersionTransitions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        noncurrentVersionExpiration.map(value => value.asEditable),
        abortIncompleteMultipartUpload.map(value => value.asEditable)
      )
    def expiration: Optional[zio.aws.s3.model.LifecycleExpiration.ReadOnly]
    def id: Optional[ID]
    def prefix: Optional[Prefix]
    def filter: Optional[zio.aws.s3.model.LifecycleRuleFilter.ReadOnly]
    def status: zio.aws.s3.model.ExpirationStatus
    def transitions: Optional[List[zio.aws.s3.model.Transition.ReadOnly]]
    def noncurrentVersionTransitions
        : Optional[List[zio.aws.s3.model.NoncurrentVersionTransition.ReadOnly]]
    def noncurrentVersionExpiration
        : Optional[zio.aws.s3.model.NoncurrentVersionExpiration.ReadOnly]
    def abortIncompleteMultipartUpload
        : Optional[zio.aws.s3.model.AbortIncompleteMultipartUpload.ReadOnly]
    def getExpiration
        : ZIO[Any, AwsError, zio.aws.s3.model.LifecycleExpiration.ReadOnly] =
      AwsError.unwrapOptionField("expiration", expiration)
    def getId: ZIO[Any, AwsError, ID] = AwsError.unwrapOptionField("id", id)
    def getPrefix: ZIO[Any, AwsError, Prefix] =
      AwsError.unwrapOptionField("prefix", prefix)
    def getFilter
        : ZIO[Any, AwsError, zio.aws.s3.model.LifecycleRuleFilter.ReadOnly] =
      AwsError.unwrapOptionField("filter", filter)
    def getStatus: ZIO[Any, Nothing, zio.aws.s3.model.ExpirationStatus] =
      ZIO.succeed(status)
    def getTransitions
        : ZIO[Any, AwsError, List[zio.aws.s3.model.Transition.ReadOnly]] =
      AwsError.unwrapOptionField("transitions", transitions)
    def getNoncurrentVersionTransitions: ZIO[Any, AwsError, List[
      zio.aws.s3.model.NoncurrentVersionTransition.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "noncurrentVersionTransitions",
      noncurrentVersionTransitions
    )
    def getNoncurrentVersionExpiration: ZIO[
      Any,
      AwsError,
      zio.aws.s3.model.NoncurrentVersionExpiration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "noncurrentVersionExpiration",
      noncurrentVersionExpiration
    )
    def getAbortIncompleteMultipartUpload: ZIO[
      Any,
      AwsError,
      zio.aws.s3.model.AbortIncompleteMultipartUpload.ReadOnly
    ] = AwsError.unwrapOptionField(
      "abortIncompleteMultipartUpload",
      abortIncompleteMultipartUpload
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.LifecycleRule
  ) extends zio.aws.s3.model.LifecycleRule.ReadOnly {
    override val expiration
        : Optional[zio.aws.s3.model.LifecycleExpiration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.expiration())
        .map(value => zio.aws.s3.model.LifecycleExpiration.wrap(value))
    override val id: Optional[ID] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.s3.model.primitives.ID(value))
    override val prefix: Optional[Prefix] = zio.aws.core.internal
      .optionalFromNullable(impl.prefix())
      .map(value => zio.aws.s3.model.primitives.Prefix(value))
    override val filter
        : Optional[zio.aws.s3.model.LifecycleRuleFilter.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filter())
        .map(value => zio.aws.s3.model.LifecycleRuleFilter.wrap(value))
    override val status: zio.aws.s3.model.ExpirationStatus =
      zio.aws.s3.model.ExpirationStatus.wrap(impl.status())
    override val transitions
        : Optional[List[zio.aws.s3.model.Transition.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.transitions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.s3.model.Transition.wrap(item)
          }.toList
        )
    override val noncurrentVersionTransitions: Optional[
      List[zio.aws.s3.model.NoncurrentVersionTransition.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.noncurrentVersionTransitions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.s3.model.NoncurrentVersionTransition.wrap(item)
        }.toList
      )
    override val noncurrentVersionExpiration
        : Optional[zio.aws.s3.model.NoncurrentVersionExpiration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.noncurrentVersionExpiration())
        .map(value => zio.aws.s3.model.NoncurrentVersionExpiration.wrap(value))
    override val abortIncompleteMultipartUpload
        : Optional[zio.aws.s3.model.AbortIncompleteMultipartUpload.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.abortIncompleteMultipartUpload())
        .map(value =>
          zio.aws.s3.model.AbortIncompleteMultipartUpload.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.LifecycleRule
  ): zio.aws.s3.model.LifecycleRule.ReadOnly = new Wrapper(impl)
}
