package zio.aws.s3.model
import zio.aws.s3.model.primitives.{NextToken, Token, IsTruncated}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListBucketIntelligentTieringConfigurationsResponse(
    isTruncated: Optional[IsTruncated] = Optional.Absent,
    continuationToken: Optional[Token] = Optional.Absent,
    nextContinuationToken: Optional[NextToken] = Optional.Absent,
    intelligentTieringConfigurationList: Optional[
      Iterable[zio.aws.s3.model.IntelligentTieringConfiguration]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.ListBucketIntelligentTieringConfigurationsResponse = {
    import ListBucketIntelligentTieringConfigurationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.ListBucketIntelligentTieringConfigurationsResponse
      .builder()
      .optionallyWith(
        isTruncated.map(value => IsTruncated.unwrap(value): java.lang.Boolean)
      )(_.isTruncated)
      .optionallyWith(
        continuationToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.continuationToken)
      .optionallyWith(
        nextContinuationToken.map(value =>
          NextToken.unwrap(value): java.lang.String
        )
      )(_.nextContinuationToken)
      .optionallyWith(
        intelligentTieringConfigurationList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.intelligentTieringConfigurationList)
      .build()
  }
  def asReadOnly
      : zio.aws.s3.model.ListBucketIntelligentTieringConfigurationsResponse.ReadOnly =
    zio.aws.s3.model.ListBucketIntelligentTieringConfigurationsResponse
      .wrap(buildAwsValue())
}
object ListBucketIntelligentTieringConfigurationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.ListBucketIntelligentTieringConfigurationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.s3.model.ListBucketIntelligentTieringConfigurationsResponse =
      zio.aws.s3.model.ListBucketIntelligentTieringConfigurationsResponse(
        isTruncated.map(value => value),
        continuationToken.map(value => value),
        nextContinuationToken.map(value => value),
        intelligentTieringConfigurationList.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def isTruncated: Optional[IsTruncated]
    def continuationToken: Optional[Token]
    def nextContinuationToken: Optional[NextToken]
    def intelligentTieringConfigurationList: Optional[
      List[zio.aws.s3.model.IntelligentTieringConfiguration.ReadOnly]
    ]
    def getIsTruncated: ZIO[Any, AwsError, IsTruncated] =
      AwsError.unwrapOptionField("isTruncated", isTruncated)
    def getContinuationToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("continuationToken", continuationToken)
    def getNextContinuationToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextContinuationToken", nextContinuationToken)
    def getIntelligentTieringConfigurationList: ZIO[Any, AwsError, List[
      zio.aws.s3.model.IntelligentTieringConfiguration.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "intelligentTieringConfigurationList",
      intelligentTieringConfigurationList
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.ListBucketIntelligentTieringConfigurationsResponse
  ) extends zio.aws.s3.model.ListBucketIntelligentTieringConfigurationsResponse.ReadOnly {
    override val isTruncated: Optional[IsTruncated] = zio.aws.core.internal
      .optionalFromNullable(impl.isTruncated())
      .map(value => zio.aws.s3.model.primitives.IsTruncated(value))
    override val continuationToken: Optional[Token] = zio.aws.core.internal
      .optionalFromNullable(impl.continuationToken())
      .map(value => zio.aws.s3.model.primitives.Token(value))
    override val nextContinuationToken: Optional[NextToken] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nextContinuationToken())
        .map(value => zio.aws.s3.model.primitives.NextToken(value))
    override val intelligentTieringConfigurationList: Optional[
      List[zio.aws.s3.model.IntelligentTieringConfiguration.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.intelligentTieringConfigurationList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.s3.model.IntelligentTieringConfiguration.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.ListBucketIntelligentTieringConfigurationsResponse
  ): zio.aws.s3.model.ListBucketIntelligentTieringConfigurationsResponse.ReadOnly =
    new Wrapper(impl)
}
