package zio.aws.s3.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListBucketsResponse(
    buckets: Optional[Iterable[zio.aws.s3.model.Bucket]] = Optional.Absent,
    owner: Optional[zio.aws.s3.model.Owner] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.ListBucketsResponse = {
    import ListBucketsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.ListBucketsResponse
      .builder()
      .optionallyWith(
        buckets.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.buckets)
      .optionallyWith(owner.map(value => value.buildAwsValue()))(_.owner)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.ListBucketsResponse.ReadOnly =
    zio.aws.s3.model.ListBucketsResponse.wrap(buildAwsValue())
}
object ListBucketsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.ListBucketsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.ListBucketsResponse =
      zio.aws.s3.model.ListBucketsResponse(
        buckets.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        owner.map(value => value.asEditable)
      )
    def buckets: Optional[List[zio.aws.s3.model.Bucket.ReadOnly]]
    def owner: Optional[zio.aws.s3.model.Owner.ReadOnly]
    def getBuckets: ZIO[Any, AwsError, List[zio.aws.s3.model.Bucket.ReadOnly]] =
      AwsError.unwrapOptionField("buckets", buckets)
    def getOwner: ZIO[Any, AwsError, zio.aws.s3.model.Owner.ReadOnly] =
      AwsError.unwrapOptionField("owner", owner)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.ListBucketsResponse
  ) extends zio.aws.s3.model.ListBucketsResponse.ReadOnly {
    override val buckets: Optional[List[zio.aws.s3.model.Bucket.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.buckets())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.s3.model.Bucket.wrap(item)
          }.toList
        )
    override val owner: Optional[zio.aws.s3.model.Owner.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.owner())
        .map(value => zio.aws.s3.model.Owner.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.ListBucketsResponse
  ): zio.aws.s3.model.ListBucketsResponse.ReadOnly = new Wrapper(impl)
}
