package zio.aws.s3.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.s3.model.primitives.{
  Prefix,
  MaxUploads,
  Delimiter,
  BucketName,
  KeyMarker,
  IsTruncated,
  NextKeyMarker,
  NextUploadIdMarker,
  UploadIdMarker
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListMultipartUploadsResponse(
    bucket: Optional[BucketName] = Optional.Absent,
    keyMarker: Optional[KeyMarker] = Optional.Absent,
    uploadIdMarker: Optional[UploadIdMarker] = Optional.Absent,
    nextKeyMarker: Optional[NextKeyMarker] = Optional.Absent,
    prefix: Optional[Prefix] = Optional.Absent,
    delimiter: Optional[Delimiter] = Optional.Absent,
    nextUploadIdMarker: Optional[NextUploadIdMarker] = Optional.Absent,
    maxUploads: Optional[MaxUploads] = Optional.Absent,
    isTruncated: Optional[IsTruncated] = Optional.Absent,
    uploads: Optional[Iterable[zio.aws.s3.model.MultipartUpload]] =
      Optional.Absent,
    commonPrefixes: Optional[Iterable[zio.aws.s3.model.CommonPrefix]] =
      Optional.Absent,
    encodingType: Optional[zio.aws.s3.model.EncodingType] = Optional.Absent,
    requestCharged: Optional[zio.aws.s3.model.RequestCharged] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.ListMultipartUploadsResponse = {
    import ListMultipartUploadsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.ListMultipartUploadsResponse
      .builder()
      .optionallyWith(
        bucket.map(value => BucketName.unwrap(value): java.lang.String)
      )(_.bucket)
      .optionallyWith(
        keyMarker.map(value => KeyMarker.unwrap(value): java.lang.String)
      )(_.keyMarker)
      .optionallyWith(
        uploadIdMarker.map(value =>
          UploadIdMarker.unwrap(value): java.lang.String
        )
      )(_.uploadIdMarker)
      .optionallyWith(
        nextKeyMarker.map(value =>
          NextKeyMarker.unwrap(value): java.lang.String
        )
      )(_.nextKeyMarker)
      .optionallyWith(
        prefix.map(value => Prefix.unwrap(value): java.lang.String)
      )(_.prefix)
      .optionallyWith(
        delimiter.map(value => Delimiter.unwrap(value): java.lang.String)
      )(_.delimiter)
      .optionallyWith(
        nextUploadIdMarker.map(value =>
          NextUploadIdMarker.unwrap(value): java.lang.String
        )
      )(_.nextUploadIdMarker)
      .optionallyWith(
        maxUploads.map(value => MaxUploads.unwrap(value): Integer)
      )(_.maxUploads)
      .optionallyWith(
        isTruncated.map(value => IsTruncated.unwrap(value): java.lang.Boolean)
      )(_.isTruncated)
      .optionallyWith(
        uploads.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.uploads)
      .optionallyWith(
        commonPrefixes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.commonPrefixes)
      .optionallyWith(encodingType.map(value => value.unwrap))(_.encodingType)
      .optionallyWith(requestCharged.map(value => value.unwrap))(
        _.requestCharged
      )
      .build()
  }
  def asReadOnly: zio.aws.s3.model.ListMultipartUploadsResponse.ReadOnly =
    zio.aws.s3.model.ListMultipartUploadsResponse.wrap(buildAwsValue())
}
object ListMultipartUploadsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.ListMultipartUploadsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.ListMultipartUploadsResponse =
      zio.aws.s3.model.ListMultipartUploadsResponse(
        bucket.map(value => value),
        keyMarker.map(value => value),
        uploadIdMarker.map(value => value),
        nextKeyMarker.map(value => value),
        prefix.map(value => value),
        delimiter.map(value => value),
        nextUploadIdMarker.map(value => value),
        maxUploads.map(value => value),
        isTruncated.map(value => value),
        uploads.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        commonPrefixes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        encodingType.map(value => value),
        requestCharged.map(value => value)
      )
    def bucket: Optional[BucketName]
    def keyMarker: Optional[KeyMarker]
    def uploadIdMarker: Optional[UploadIdMarker]
    def nextKeyMarker: Optional[NextKeyMarker]
    def prefix: Optional[Prefix]
    def delimiter: Optional[Delimiter]
    def nextUploadIdMarker: Optional[NextUploadIdMarker]
    def maxUploads: Optional[MaxUploads]
    def isTruncated: Optional[IsTruncated]
    def uploads: Optional[List[zio.aws.s3.model.MultipartUpload.ReadOnly]]
    def commonPrefixes: Optional[List[zio.aws.s3.model.CommonPrefix.ReadOnly]]
    def encodingType: Optional[zio.aws.s3.model.EncodingType]
    def requestCharged: Optional[zio.aws.s3.model.RequestCharged]
    def getBucket: ZIO[Any, AwsError, BucketName] =
      AwsError.unwrapOptionField("bucket", bucket)
    def getKeyMarker: ZIO[Any, AwsError, KeyMarker] =
      AwsError.unwrapOptionField("keyMarker", keyMarker)
    def getUploadIdMarker: ZIO[Any, AwsError, UploadIdMarker] =
      AwsError.unwrapOptionField("uploadIdMarker", uploadIdMarker)
    def getNextKeyMarker: ZIO[Any, AwsError, NextKeyMarker] =
      AwsError.unwrapOptionField("nextKeyMarker", nextKeyMarker)
    def getPrefix: ZIO[Any, AwsError, Prefix] =
      AwsError.unwrapOptionField("prefix", prefix)
    def getDelimiter: ZIO[Any, AwsError, Delimiter] =
      AwsError.unwrapOptionField("delimiter", delimiter)
    def getNextUploadIdMarker: ZIO[Any, AwsError, NextUploadIdMarker] =
      AwsError.unwrapOptionField("nextUploadIdMarker", nextUploadIdMarker)
    def getMaxUploads: ZIO[Any, AwsError, MaxUploads] =
      AwsError.unwrapOptionField("maxUploads", maxUploads)
    def getIsTruncated: ZIO[Any, AwsError, IsTruncated] =
      AwsError.unwrapOptionField("isTruncated", isTruncated)
    def getUploads
        : ZIO[Any, AwsError, List[zio.aws.s3.model.MultipartUpload.ReadOnly]] =
      AwsError.unwrapOptionField("uploads", uploads)
    def getCommonPrefixes
        : ZIO[Any, AwsError, List[zio.aws.s3.model.CommonPrefix.ReadOnly]] =
      AwsError.unwrapOptionField("commonPrefixes", commonPrefixes)
    def getEncodingType: ZIO[Any, AwsError, zio.aws.s3.model.EncodingType] =
      AwsError.unwrapOptionField("encodingType", encodingType)
    def getRequestCharged: ZIO[Any, AwsError, zio.aws.s3.model.RequestCharged] =
      AwsError.unwrapOptionField("requestCharged", requestCharged)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.ListMultipartUploadsResponse
  ) extends zio.aws.s3.model.ListMultipartUploadsResponse.ReadOnly {
    override val bucket: Optional[BucketName] = zio.aws.core.internal
      .optionalFromNullable(impl.bucket())
      .map(value => zio.aws.s3.model.primitives.BucketName(value))
    override val keyMarker: Optional[KeyMarker] = zio.aws.core.internal
      .optionalFromNullable(impl.keyMarker())
      .map(value => zio.aws.s3.model.primitives.KeyMarker(value))
    override val uploadIdMarker: Optional[UploadIdMarker] =
      zio.aws.core.internal
        .optionalFromNullable(impl.uploadIdMarker())
        .map(value => zio.aws.s3.model.primitives.UploadIdMarker(value))
    override val nextKeyMarker: Optional[NextKeyMarker] = zio.aws.core.internal
      .optionalFromNullable(impl.nextKeyMarker())
      .map(value => zio.aws.s3.model.primitives.NextKeyMarker(value))
    override val prefix: Optional[Prefix] = zio.aws.core.internal
      .optionalFromNullable(impl.prefix())
      .map(value => zio.aws.s3.model.primitives.Prefix(value))
    override val delimiter: Optional[Delimiter] = zio.aws.core.internal
      .optionalFromNullable(impl.delimiter())
      .map(value => zio.aws.s3.model.primitives.Delimiter(value))
    override val nextUploadIdMarker: Optional[NextUploadIdMarker] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nextUploadIdMarker())
        .map(value => zio.aws.s3.model.primitives.NextUploadIdMarker(value))
    override val maxUploads: Optional[MaxUploads] = zio.aws.core.internal
      .optionalFromNullable(impl.maxUploads())
      .map(value => zio.aws.s3.model.primitives.MaxUploads(value))
    override val isTruncated: Optional[IsTruncated] = zio.aws.core.internal
      .optionalFromNullable(impl.isTruncated())
      .map(value => zio.aws.s3.model.primitives.IsTruncated(value))
    override val uploads
        : Optional[List[zio.aws.s3.model.MultipartUpload.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.uploads())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.s3.model.MultipartUpload.wrap(item)
          }.toList
        )
    override val commonPrefixes
        : Optional[List[zio.aws.s3.model.CommonPrefix.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.commonPrefixes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.s3.model.CommonPrefix.wrap(item)
          }.toList
        )
    override val encodingType: Optional[zio.aws.s3.model.EncodingType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.encodingType())
        .map(value => zio.aws.s3.model.EncodingType.wrap(value))
    override val requestCharged: Optional[zio.aws.s3.model.RequestCharged] =
      zio.aws.core.internal
        .optionalFromNullable(impl.requestCharged())
        .map(value => zio.aws.s3.model.RequestCharged.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.ListMultipartUploadsResponse
  ): zio.aws.s3.model.ListMultipartUploadsResponse.ReadOnly = new Wrapper(impl)
}
