package zio.aws.s3.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.s3.model.primitives.{
  Marker,
  MaxKeys,
  Prefix,
  AccountId,
  Delimiter,
  BucketName
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListObjectsRequest(
    bucket: BucketName,
    delimiter: Optional[Delimiter] = Optional.Absent,
    encodingType: Optional[zio.aws.s3.model.EncodingType] = Optional.Absent,
    marker: Optional[Marker] = Optional.Absent,
    maxKeys: Optional[MaxKeys] = Optional.Absent,
    prefix: Optional[Prefix] = Optional.Absent,
    requestPayer: Optional[zio.aws.s3.model.RequestPayer] = Optional.Absent,
    expectedBucketOwner: Optional[AccountId] = Optional.Absent,
    optionalObjectAttributes: Optional[
      Iterable[zio.aws.s3.model.OptionalObjectAttributes]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.ListObjectsRequest = {
    import ListObjectsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.ListObjectsRequest
      .builder()
      .bucket(BucketName.unwrap(bucket): java.lang.String)
      .optionallyWith(
        delimiter.map(value => Delimiter.unwrap(value): java.lang.String)
      )(_.delimiter)
      .optionallyWith(encodingType.map(value => value.unwrap))(_.encodingType)
      .optionallyWith(
        marker.map(value => Marker.unwrap(value): java.lang.String)
      )(_.marker)
      .optionallyWith(maxKeys.map(value => MaxKeys.unwrap(value): Integer))(
        _.maxKeys
      )
      .optionallyWith(
        prefix.map(value => Prefix.unwrap(value): java.lang.String)
      )(_.prefix)
      .optionallyWith(requestPayer.map(value => value.unwrap))(_.requestPayer)
      .optionallyWith(
        expectedBucketOwner.map(value =>
          AccountId.unwrap(value): java.lang.String
        )
      )(_.expectedBucketOwner)
      .optionallyWith(
        optionalObjectAttributes.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.optionalObjectAttributesWithStrings)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.ListObjectsRequest.ReadOnly =
    zio.aws.s3.model.ListObjectsRequest.wrap(buildAwsValue())
}
object ListObjectsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.ListObjectsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.ListObjectsRequest =
      zio.aws.s3.model.ListObjectsRequest(
        bucket,
        delimiter.map(value => value),
        encodingType.map(value => value),
        marker.map(value => value),
        maxKeys.map(value => value),
        prefix.map(value => value),
        requestPayer.map(value => value),
        expectedBucketOwner.map(value => value),
        optionalObjectAttributes.map(value => value)
      )
    def bucket: BucketName
    def delimiter: Optional[Delimiter]
    def encodingType: Optional[zio.aws.s3.model.EncodingType]
    def marker: Optional[Marker]
    def maxKeys: Optional[MaxKeys]
    def prefix: Optional[Prefix]
    def requestPayer: Optional[zio.aws.s3.model.RequestPayer]
    def expectedBucketOwner: Optional[AccountId]
    def optionalObjectAttributes
        : Optional[List[zio.aws.s3.model.OptionalObjectAttributes]]
    def getBucket: ZIO[Any, Nothing, BucketName] = ZIO.succeed(bucket)
    def getDelimiter: ZIO[Any, AwsError, Delimiter] =
      AwsError.unwrapOptionField("delimiter", delimiter)
    def getEncodingType: ZIO[Any, AwsError, zio.aws.s3.model.EncodingType] =
      AwsError.unwrapOptionField("encodingType", encodingType)
    def getMarker: ZIO[Any, AwsError, Marker] =
      AwsError.unwrapOptionField("marker", marker)
    def getMaxKeys: ZIO[Any, AwsError, MaxKeys] =
      AwsError.unwrapOptionField("maxKeys", maxKeys)
    def getPrefix: ZIO[Any, AwsError, Prefix] =
      AwsError.unwrapOptionField("prefix", prefix)
    def getRequestPayer: ZIO[Any, AwsError, zio.aws.s3.model.RequestPayer] =
      AwsError.unwrapOptionField("requestPayer", requestPayer)
    def getExpectedBucketOwner: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("expectedBucketOwner", expectedBucketOwner)
    def getOptionalObjectAttributes
        : ZIO[Any, AwsError, List[zio.aws.s3.model.OptionalObjectAttributes]] =
      AwsError.unwrapOptionField(
        "optionalObjectAttributes",
        optionalObjectAttributes
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.ListObjectsRequest
  ) extends zio.aws.s3.model.ListObjectsRequest.ReadOnly {
    override val bucket: BucketName =
      zio.aws.s3.model.primitives.BucketName(impl.bucket())
    override val delimiter: Optional[Delimiter] = zio.aws.core.internal
      .optionalFromNullable(impl.delimiter())
      .map(value => zio.aws.s3.model.primitives.Delimiter(value))
    override val encodingType: Optional[zio.aws.s3.model.EncodingType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.encodingType())
        .map(value => zio.aws.s3.model.EncodingType.wrap(value))
    override val marker: Optional[Marker] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => zio.aws.s3.model.primitives.Marker(value))
    override val maxKeys: Optional[MaxKeys] = zio.aws.core.internal
      .optionalFromNullable(impl.maxKeys())
      .map(value => zio.aws.s3.model.primitives.MaxKeys(value))
    override val prefix: Optional[Prefix] = zio.aws.core.internal
      .optionalFromNullable(impl.prefix())
      .map(value => zio.aws.s3.model.primitives.Prefix(value))
    override val requestPayer: Optional[zio.aws.s3.model.RequestPayer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.requestPayer())
        .map(value => zio.aws.s3.model.RequestPayer.wrap(value))
    override val expectedBucketOwner: Optional[AccountId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.expectedBucketOwner())
        .map(value => zio.aws.s3.model.primitives.AccountId(value))
    override val optionalObjectAttributes
        : Optional[List[zio.aws.s3.model.OptionalObjectAttributes]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.optionalObjectAttributes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.s3.model.OptionalObjectAttributes.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.ListObjectsRequest
  ): zio.aws.s3.model.ListObjectsRequest.ReadOnly = new Wrapper(impl)
}
