package zio.aws.s3.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.s3.model.primitives.{
  MaxKeys,
  NextToken,
  Token,
  Prefix,
  StartAfter,
  Delimiter,
  BucketName,
  IsTruncated,
  KeyCount
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListObjectsV2Response(
    isTruncated: Optional[IsTruncated] = Optional.Absent,
    contents: Optional[Iterable[zio.aws.s3.model.S3Object]] = Optional.Absent,
    name: Optional[BucketName] = Optional.Absent,
    prefix: Optional[Prefix] = Optional.Absent,
    delimiter: Optional[Delimiter] = Optional.Absent,
    maxKeys: Optional[MaxKeys] = Optional.Absent,
    commonPrefixes: Optional[Iterable[zio.aws.s3.model.CommonPrefix]] =
      Optional.Absent,
    encodingType: Optional[zio.aws.s3.model.EncodingType] = Optional.Absent,
    keyCount: Optional[KeyCount] = Optional.Absent,
    continuationToken: Optional[Token] = Optional.Absent,
    nextContinuationToken: Optional[NextToken] = Optional.Absent,
    startAfter: Optional[StartAfter] = Optional.Absent,
    requestCharged: Optional[zio.aws.s3.model.RequestCharged] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.ListObjectsV2Response = {
    import ListObjectsV2Response.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.ListObjectsV2Response
      .builder()
      .optionallyWith(
        isTruncated.map(value => IsTruncated.unwrap(value): java.lang.Boolean)
      )(_.isTruncated)
      .optionallyWith(
        contents.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.contents)
      .optionallyWith(
        name.map(value => BucketName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        prefix.map(value => Prefix.unwrap(value): java.lang.String)
      )(_.prefix)
      .optionallyWith(
        delimiter.map(value => Delimiter.unwrap(value): java.lang.String)
      )(_.delimiter)
      .optionallyWith(maxKeys.map(value => MaxKeys.unwrap(value): Integer))(
        _.maxKeys
      )
      .optionallyWith(
        commonPrefixes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.commonPrefixes)
      .optionallyWith(encodingType.map(value => value.unwrap))(_.encodingType)
      .optionallyWith(keyCount.map(value => KeyCount.unwrap(value): Integer))(
        _.keyCount
      )
      .optionallyWith(
        continuationToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.continuationToken)
      .optionallyWith(
        nextContinuationToken.map(value =>
          NextToken.unwrap(value): java.lang.String
        )
      )(_.nextContinuationToken)
      .optionallyWith(
        startAfter.map(value => StartAfter.unwrap(value): java.lang.String)
      )(_.startAfter)
      .optionallyWith(requestCharged.map(value => value.unwrap))(
        _.requestCharged
      )
      .build()
  }
  def asReadOnly: zio.aws.s3.model.ListObjectsV2Response.ReadOnly =
    zio.aws.s3.model.ListObjectsV2Response.wrap(buildAwsValue())
}
object ListObjectsV2Response {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.ListObjectsV2Response
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.ListObjectsV2Response =
      zio.aws.s3.model.ListObjectsV2Response(
        isTruncated.map(value => value),
        contents.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        name.map(value => value),
        prefix.map(value => value),
        delimiter.map(value => value),
        maxKeys.map(value => value),
        commonPrefixes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        encodingType.map(value => value),
        keyCount.map(value => value),
        continuationToken.map(value => value),
        nextContinuationToken.map(value => value),
        startAfter.map(value => value),
        requestCharged.map(value => value)
      )
    def isTruncated: Optional[IsTruncated]
    def contents: Optional[List[zio.aws.s3.model.S3Object.ReadOnly]]
    def name: Optional[BucketName]
    def prefix: Optional[Prefix]
    def delimiter: Optional[Delimiter]
    def maxKeys: Optional[MaxKeys]
    def commonPrefixes: Optional[List[zio.aws.s3.model.CommonPrefix.ReadOnly]]
    def encodingType: Optional[zio.aws.s3.model.EncodingType]
    def keyCount: Optional[KeyCount]
    def continuationToken: Optional[Token]
    def nextContinuationToken: Optional[NextToken]
    def startAfter: Optional[StartAfter]
    def requestCharged: Optional[zio.aws.s3.model.RequestCharged]
    def getIsTruncated: ZIO[Any, AwsError, IsTruncated] =
      AwsError.unwrapOptionField("isTruncated", isTruncated)
    def getContents
        : ZIO[Any, AwsError, List[zio.aws.s3.model.S3Object.ReadOnly]] =
      AwsError.unwrapOptionField("contents", contents)
    def getName: ZIO[Any, AwsError, BucketName] =
      AwsError.unwrapOptionField("name", name)
    def getPrefix: ZIO[Any, AwsError, Prefix] =
      AwsError.unwrapOptionField("prefix", prefix)
    def getDelimiter: ZIO[Any, AwsError, Delimiter] =
      AwsError.unwrapOptionField("delimiter", delimiter)
    def getMaxKeys: ZIO[Any, AwsError, MaxKeys] =
      AwsError.unwrapOptionField("maxKeys", maxKeys)
    def getCommonPrefixes
        : ZIO[Any, AwsError, List[zio.aws.s3.model.CommonPrefix.ReadOnly]] =
      AwsError.unwrapOptionField("commonPrefixes", commonPrefixes)
    def getEncodingType: ZIO[Any, AwsError, zio.aws.s3.model.EncodingType] =
      AwsError.unwrapOptionField("encodingType", encodingType)
    def getKeyCount: ZIO[Any, AwsError, KeyCount] =
      AwsError.unwrapOptionField("keyCount", keyCount)
    def getContinuationToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("continuationToken", continuationToken)
    def getNextContinuationToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextContinuationToken", nextContinuationToken)
    def getStartAfter: ZIO[Any, AwsError, StartAfter] =
      AwsError.unwrapOptionField("startAfter", startAfter)
    def getRequestCharged: ZIO[Any, AwsError, zio.aws.s3.model.RequestCharged] =
      AwsError.unwrapOptionField("requestCharged", requestCharged)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.ListObjectsV2Response
  ) extends zio.aws.s3.model.ListObjectsV2Response.ReadOnly {
    override val isTruncated: Optional[IsTruncated] = zio.aws.core.internal
      .optionalFromNullable(impl.isTruncated())
      .map(value => zio.aws.s3.model.primitives.IsTruncated(value))
    override val contents: Optional[List[zio.aws.s3.model.S3Object.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.contents())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.s3.model.S3Object.wrap(item)
          }.toList
        )
    override val name: Optional[BucketName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.s3.model.primitives.BucketName(value))
    override val prefix: Optional[Prefix] = zio.aws.core.internal
      .optionalFromNullable(impl.prefix())
      .map(value => zio.aws.s3.model.primitives.Prefix(value))
    override val delimiter: Optional[Delimiter] = zio.aws.core.internal
      .optionalFromNullable(impl.delimiter())
      .map(value => zio.aws.s3.model.primitives.Delimiter(value))
    override val maxKeys: Optional[MaxKeys] = zio.aws.core.internal
      .optionalFromNullable(impl.maxKeys())
      .map(value => zio.aws.s3.model.primitives.MaxKeys(value))
    override val commonPrefixes
        : Optional[List[zio.aws.s3.model.CommonPrefix.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.commonPrefixes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.s3.model.CommonPrefix.wrap(item)
          }.toList
        )
    override val encodingType: Optional[zio.aws.s3.model.EncodingType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.encodingType())
        .map(value => zio.aws.s3.model.EncodingType.wrap(value))
    override val keyCount: Optional[KeyCount] = zio.aws.core.internal
      .optionalFromNullable(impl.keyCount())
      .map(value => zio.aws.s3.model.primitives.KeyCount(value))
    override val continuationToken: Optional[Token] = zio.aws.core.internal
      .optionalFromNullable(impl.continuationToken())
      .map(value => zio.aws.s3.model.primitives.Token(value))
    override val nextContinuationToken: Optional[NextToken] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nextContinuationToken())
        .map(value => zio.aws.s3.model.primitives.NextToken(value))
    override val startAfter: Optional[StartAfter] = zio.aws.core.internal
      .optionalFromNullable(impl.startAfter())
      .map(value => zio.aws.s3.model.primitives.StartAfter(value))
    override val requestCharged: Optional[zio.aws.s3.model.RequestCharged] =
      zio.aws.core.internal
        .optionalFromNullable(impl.requestCharged())
        .map(value => zio.aws.s3.model.RequestCharged.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.ListObjectsV2Response
  ): zio.aws.s3.model.ListObjectsV2Response.ReadOnly = new Wrapper(impl)
}
