package zio.aws.s3.model
import scala.jdk.CollectionConverters.*
sealed trait MFADeleteStatus {
  def unwrap: software.amazon.awssdk.services.s3.model.MFADeleteStatus
}
object MFADeleteStatus {
  def wrap(
      value: software.amazon.awssdk.services.s3.model.MFADeleteStatus
  ): zio.aws.s3.model.MFADeleteStatus = value match {
    case software.amazon.awssdk.services.s3.model.MFADeleteStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.s3.model.MFADeleteStatus.ENABLED =>
      val r = Enabled
      r
    case software.amazon.awssdk.services.s3.model.MFADeleteStatus.DISABLED =>
      val r = Disabled
      r
  }
  case object unknownToSdkVersion extends zio.aws.s3.model.MFADeleteStatus {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.MFADeleteStatus =
      software.amazon.awssdk.services.s3.model.MFADeleteStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object Enabled extends zio.aws.s3.model.MFADeleteStatus {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.MFADeleteStatus =
      software.amazon.awssdk.services.s3.model.MFADeleteStatus.ENABLED
  }
  case object Disabled extends zio.aws.s3.model.MFADeleteStatus {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.MFADeleteStatus =
      software.amazon.awssdk.services.s3.model.MFADeleteStatus.DISABLED
  }
}
