package zio.aws.s3.model
import zio.aws.s3.model.primitives.{MetadataValue, MetadataKey}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class MetadataEntry(
    name: Optional[MetadataKey] = Optional.Absent,
    value: Optional[MetadataValue] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.MetadataEntry = {
    import MetadataEntry.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.MetadataEntry
      .builder()
      .optionallyWith(
        name.map(value => MetadataKey.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        value.map(value => MetadataValue.unwrap(value): java.lang.String)
      )(_.value)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.MetadataEntry.ReadOnly =
    zio.aws.s3.model.MetadataEntry.wrap(buildAwsValue())
}
object MetadataEntry {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.s3.model.MetadataEntry] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.MetadataEntry = zio.aws.s3.model
      .MetadataEntry(name.map(value => value), value.map(value => value))
    def name: Optional[MetadataKey]
    def value: Optional[MetadataValue]
    def getName: ZIO[Any, AwsError, MetadataKey] =
      AwsError.unwrapOptionField("name", name)
    def getValue: ZIO[Any, AwsError, MetadataValue] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.MetadataEntry
  ) extends zio.aws.s3.model.MetadataEntry.ReadOnly {
    override val name: Optional[MetadataKey] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.s3.model.primitives.MetadataKey(value))
    override val value: Optional[MetadataValue] = zio.aws.core.internal
      .optionalFromNullable(impl.value())
      .map(value => zio.aws.s3.model.primitives.MetadataValue(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.MetadataEntry
  ): zio.aws.s3.model.MetadataEntry.ReadOnly = new Wrapper(impl)
}
