package zio.aws.s3.model
import zio.aws.s3.model.primitives.{AccessPointArn, Prefix}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class MetricsFilter(
    prefix: Optional[Prefix] = Optional.Absent,
    tag: Optional[zio.aws.s3.model.Tag] = Optional.Absent,
    accessPointArn: Optional[AccessPointArn] = Optional.Absent,
    and: Optional[zio.aws.s3.model.MetricsAndOperator] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.MetricsFilter = {
    import MetricsFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.MetricsFilter
      .builder()
      .optionallyWith(
        prefix.map(value => Prefix.unwrap(value): java.lang.String)
      )(_.prefix)
      .optionallyWith(tag.map(value => value.buildAwsValue()))(_.tag)
      .optionallyWith(
        accessPointArn.map(value =>
          AccessPointArn.unwrap(value): java.lang.String
        )
      )(_.accessPointArn)
      .optionallyWith(and.map(value => value.buildAwsValue()))(_.and)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.MetricsFilter.ReadOnly =
    zio.aws.s3.model.MetricsFilter.wrap(buildAwsValue())
}
object MetricsFilter {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.s3.model.MetricsFilter] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.MetricsFilter =
      zio.aws.s3.model.MetricsFilter(
        prefix.map(value => value),
        tag.map(value => value.asEditable),
        accessPointArn.map(value => value),
        and.map(value => value.asEditable)
      )
    def prefix: Optional[Prefix]
    def tag: Optional[zio.aws.s3.model.Tag.ReadOnly]
    def accessPointArn: Optional[AccessPointArn]
    def and: Optional[zio.aws.s3.model.MetricsAndOperator.ReadOnly]
    def getPrefix: ZIO[Any, AwsError, Prefix] =
      AwsError.unwrapOptionField("prefix", prefix)
    def getTag: ZIO[Any, AwsError, zio.aws.s3.model.Tag.ReadOnly] =
      AwsError.unwrapOptionField("tag", tag)
    def getAccessPointArn: ZIO[Any, AwsError, AccessPointArn] =
      AwsError.unwrapOptionField("accessPointArn", accessPointArn)
    def getAnd
        : ZIO[Any, AwsError, zio.aws.s3.model.MetricsAndOperator.ReadOnly] =
      AwsError.unwrapOptionField("and", and)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.MetricsFilter
  ) extends zio.aws.s3.model.MetricsFilter.ReadOnly {
    override val prefix: Optional[Prefix] = zio.aws.core.internal
      .optionalFromNullable(impl.prefix())
      .map(value => zio.aws.s3.model.primitives.Prefix(value))
    override val tag: Optional[zio.aws.s3.model.Tag.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tag())
        .map(value => zio.aws.s3.model.Tag.wrap(value))
    override val accessPointArn: Optional[AccessPointArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.accessPointArn())
        .map(value => zio.aws.s3.model.primitives.AccessPointArn(value))
    override val and: Optional[zio.aws.s3.model.MetricsAndOperator.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.and())
        .map(value => zio.aws.s3.model.MetricsAndOperator.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.MetricsFilter
  ): zio.aws.s3.model.MetricsFilter.ReadOnly = new Wrapper(impl)
}
