package zio.aws.s3.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.s3.model.primitives.{Initiated, ObjectKey, MultipartUploadId}
import scala.jdk.CollectionConverters.*
final case class MultipartUpload(
    uploadId: Optional[MultipartUploadId] = Optional.Absent,
    key: Optional[ObjectKey] = Optional.Absent,
    initiated: Optional[Initiated] = Optional.Absent,
    storageClass: Optional[zio.aws.s3.model.StorageClass] = Optional.Absent,
    owner: Optional[zio.aws.s3.model.Owner] = Optional.Absent,
    initiator: Optional[zio.aws.s3.model.Initiator] = Optional.Absent,
    checksumAlgorithm: Optional[zio.aws.s3.model.ChecksumAlgorithm] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.MultipartUpload = {
    import MultipartUpload.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.MultipartUpload
      .builder()
      .optionallyWith(
        uploadId.map(value => MultipartUploadId.unwrap(value): java.lang.String)
      )(_.uploadId)
      .optionallyWith(
        key.map(value => ObjectKey.unwrap(value): java.lang.String)
      )(_.key)
      .optionallyWith(initiated.map(value => Initiated.unwrap(value): Instant))(
        _.initiated
      )
      .optionallyWith(storageClass.map(value => value.unwrap))(_.storageClass)
      .optionallyWith(owner.map(value => value.buildAwsValue()))(_.owner)
      .optionallyWith(initiator.map(value => value.buildAwsValue()))(
        _.initiator
      )
      .optionallyWith(checksumAlgorithm.map(value => value.unwrap))(
        _.checksumAlgorithm
      )
      .build()
  }
  def asReadOnly: zio.aws.s3.model.MultipartUpload.ReadOnly =
    zio.aws.s3.model.MultipartUpload.wrap(buildAwsValue())
}
object MultipartUpload {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.MultipartUpload
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.MultipartUpload =
      zio.aws.s3.model.MultipartUpload(
        uploadId.map(value => value),
        key.map(value => value),
        initiated.map(value => value),
        storageClass.map(value => value),
        owner.map(value => value.asEditable),
        initiator.map(value => value.asEditable),
        checksumAlgorithm.map(value => value)
      )
    def uploadId: Optional[MultipartUploadId]
    def key: Optional[ObjectKey]
    def initiated: Optional[Initiated]
    def storageClass: Optional[zio.aws.s3.model.StorageClass]
    def owner: Optional[zio.aws.s3.model.Owner.ReadOnly]
    def initiator: Optional[zio.aws.s3.model.Initiator.ReadOnly]
    def checksumAlgorithm: Optional[zio.aws.s3.model.ChecksumAlgorithm]
    def getUploadId: ZIO[Any, AwsError, MultipartUploadId] =
      AwsError.unwrapOptionField("uploadId", uploadId)
    def getKey: ZIO[Any, AwsError, ObjectKey] =
      AwsError.unwrapOptionField("key", key)
    def getInitiated: ZIO[Any, AwsError, Initiated] =
      AwsError.unwrapOptionField("initiated", initiated)
    def getStorageClass: ZIO[Any, AwsError, zio.aws.s3.model.StorageClass] =
      AwsError.unwrapOptionField("storageClass", storageClass)
    def getOwner: ZIO[Any, AwsError, zio.aws.s3.model.Owner.ReadOnly] =
      AwsError.unwrapOptionField("owner", owner)
    def getInitiator: ZIO[Any, AwsError, zio.aws.s3.model.Initiator.ReadOnly] =
      AwsError.unwrapOptionField("initiator", initiator)
    def getChecksumAlgorithm
        : ZIO[Any, AwsError, zio.aws.s3.model.ChecksumAlgorithm] =
      AwsError.unwrapOptionField("checksumAlgorithm", checksumAlgorithm)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.MultipartUpload
  ) extends zio.aws.s3.model.MultipartUpload.ReadOnly {
    override val uploadId: Optional[MultipartUploadId] = zio.aws.core.internal
      .optionalFromNullable(impl.uploadId())
      .map(value => zio.aws.s3.model.primitives.MultipartUploadId(value))
    override val key: Optional[ObjectKey] = zio.aws.core.internal
      .optionalFromNullable(impl.key())
      .map(value => zio.aws.s3.model.primitives.ObjectKey(value))
    override val initiated: Optional[Initiated] = zio.aws.core.internal
      .optionalFromNullable(impl.initiated())
      .map(value => zio.aws.s3.model.primitives.Initiated(value))
    override val storageClass: Optional[zio.aws.s3.model.StorageClass] =
      zio.aws.core.internal
        .optionalFromNullable(impl.storageClass())
        .map(value => zio.aws.s3.model.StorageClass.wrap(value))
    override val owner: Optional[zio.aws.s3.model.Owner.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.owner())
        .map(value => zio.aws.s3.model.Owner.wrap(value))
    override val initiator: Optional[zio.aws.s3.model.Initiator.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.initiator())
        .map(value => zio.aws.s3.model.Initiator.wrap(value))
    override val checksumAlgorithm
        : Optional[zio.aws.s3.model.ChecksumAlgorithm] = zio.aws.core.internal
      .optionalFromNullable(impl.checksumAlgorithm())
      .map(value => zio.aws.s3.model.ChecksumAlgorithm.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.MultipartUpload
  ): zio.aws.s3.model.MultipartUpload.ReadOnly = new Wrapper(impl)
}
