package zio.aws.s3.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class NotificationConfiguration(
    topicConfigurations: Optional[
      Iterable[zio.aws.s3.model.TopicConfiguration]
    ] = Optional.Absent,
    queueConfigurations: Optional[
      Iterable[zio.aws.s3.model.QueueConfiguration]
    ] = Optional.Absent,
    lambdaFunctionConfigurations: Optional[
      Iterable[zio.aws.s3.model.LambdaFunctionConfiguration]
    ] = Optional.Absent,
    eventBridgeConfiguration: Optional[
      zio.aws.s3.model.EventBridgeConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.NotificationConfiguration = {
    import NotificationConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.NotificationConfiguration
      .builder()
      .optionallyWith(
        topicConfigurations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.topicConfigurations)
      .optionallyWith(
        queueConfigurations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.queueConfigurations)
      .optionallyWith(
        lambdaFunctionConfigurations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.lambdaFunctionConfigurations)
      .optionallyWith(
        eventBridgeConfiguration.map(value => value.buildAwsValue())
      )(_.eventBridgeConfiguration)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.NotificationConfiguration.ReadOnly =
    zio.aws.s3.model.NotificationConfiguration.wrap(buildAwsValue())
}
object NotificationConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.NotificationConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.NotificationConfiguration =
      zio.aws.s3.model.NotificationConfiguration(
        topicConfigurations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        queueConfigurations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        lambdaFunctionConfigurations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        eventBridgeConfiguration.map(value => value.asEditable)
      )
    def topicConfigurations
        : Optional[List[zio.aws.s3.model.TopicConfiguration.ReadOnly]]
    def queueConfigurations
        : Optional[List[zio.aws.s3.model.QueueConfiguration.ReadOnly]]
    def lambdaFunctionConfigurations
        : Optional[List[zio.aws.s3.model.LambdaFunctionConfiguration.ReadOnly]]
    def eventBridgeConfiguration
        : Optional[zio.aws.s3.model.EventBridgeConfiguration.ReadOnly]
    def getTopicConfigurations: ZIO[Any, AwsError, List[
      zio.aws.s3.model.TopicConfiguration.ReadOnly
    ]] = AwsError.unwrapOptionField("topicConfigurations", topicConfigurations)
    def getQueueConfigurations: ZIO[Any, AwsError, List[
      zio.aws.s3.model.QueueConfiguration.ReadOnly
    ]] = AwsError.unwrapOptionField("queueConfigurations", queueConfigurations)
    def getLambdaFunctionConfigurations: ZIO[Any, AwsError, List[
      zio.aws.s3.model.LambdaFunctionConfiguration.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "lambdaFunctionConfigurations",
      lambdaFunctionConfigurations
    )
    def getEventBridgeConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.s3.model.EventBridgeConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "eventBridgeConfiguration",
      eventBridgeConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.NotificationConfiguration
  ) extends zio.aws.s3.model.NotificationConfiguration.ReadOnly {
    override val topicConfigurations
        : Optional[List[zio.aws.s3.model.TopicConfiguration.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.topicConfigurations())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.s3.model.TopicConfiguration.wrap(item)
          }.toList
        )
    override val queueConfigurations
        : Optional[List[zio.aws.s3.model.QueueConfiguration.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.queueConfigurations())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.s3.model.QueueConfiguration.wrap(item)
          }.toList
        )
    override val lambdaFunctionConfigurations: Optional[
      List[zio.aws.s3.model.LambdaFunctionConfiguration.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.lambdaFunctionConfigurations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.s3.model.LambdaFunctionConfiguration.wrap(item)
        }.toList
      )
    override val eventBridgeConfiguration
        : Optional[zio.aws.s3.model.EventBridgeConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.eventBridgeConfiguration())
        .map(value => zio.aws.s3.model.EventBridgeConfiguration.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.NotificationConfiguration
  ): zio.aws.s3.model.NotificationConfiguration.ReadOnly = new Wrapper(impl)
}
