package zio.aws.s3.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.s3.model.primitives.Date
import scala.jdk.CollectionConverters.*
final case class ObjectLockRetention(
    mode: Optional[zio.aws.s3.model.ObjectLockRetentionMode] = Optional.Absent,
    retainUntilDate: Optional[Date] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.ObjectLockRetention = {
    import ObjectLockRetention.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.ObjectLockRetention
      .builder()
      .optionallyWith(mode.map(value => value.unwrap))(_.mode)
      .optionallyWith(
        retainUntilDate.map(value => Date.unwrap(value): Instant)
      )(_.retainUntilDate)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.ObjectLockRetention.ReadOnly =
    zio.aws.s3.model.ObjectLockRetention.wrap(buildAwsValue())
}
object ObjectLockRetention {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.ObjectLockRetention
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.ObjectLockRetention =
      zio.aws.s3.model.ObjectLockRetention(
        mode.map(value => value),
        retainUntilDate.map(value => value)
      )
    def mode: Optional[zio.aws.s3.model.ObjectLockRetentionMode]
    def retainUntilDate: Optional[Date]
    def getMode: ZIO[Any, AwsError, zio.aws.s3.model.ObjectLockRetentionMode] =
      AwsError.unwrapOptionField("mode", mode)
    def getRetainUntilDate: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("retainUntilDate", retainUntilDate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.ObjectLockRetention
  ) extends zio.aws.s3.model.ObjectLockRetention.ReadOnly {
    override val mode: Optional[zio.aws.s3.model.ObjectLockRetentionMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.mode())
        .map(value => zio.aws.s3.model.ObjectLockRetentionMode.wrap(value))
    override val retainUntilDate: Optional[Date] = zio.aws.core.internal
      .optionalFromNullable(impl.retainUntilDate())
      .map(value => zio.aws.s3.model.primitives.Date(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.ObjectLockRetention
  ): zio.aws.s3.model.ObjectLockRetention.ReadOnly = new Wrapper(impl)
}
