package zio.aws.s3.model
import scala.jdk.CollectionConverters.*
sealed trait OptionalObjectAttributes {
  def unwrap: software.amazon.awssdk.services.s3.model.OptionalObjectAttributes
}
object OptionalObjectAttributes {
  def wrap(
      value: software.amazon.awssdk.services.s3.model.OptionalObjectAttributes
  ): zio.aws.s3.model.OptionalObjectAttributes = value match {
    case software.amazon.awssdk.services.s3.model.OptionalObjectAttributes.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.s3.model.OptionalObjectAttributes.RESTORE_STATUS =>
      val r = RestoreStatus
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.s3.model.OptionalObjectAttributes {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.OptionalObjectAttributes =
      software.amazon.awssdk.services.s3.model.OptionalObjectAttributes.UNKNOWN_TO_SDK_VERSION
  }
  case object RestoreStatus extends zio.aws.s3.model.OptionalObjectAttributes {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.OptionalObjectAttributes =
      software.amazon.awssdk.services.s3.model.OptionalObjectAttributes.RESTORE_STATUS
  }
}
