package zio.aws.s3.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class OwnershipControlsRule(
    objectOwnership: zio.aws.s3.model.ObjectOwnership
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.OwnershipControlsRule = {
    import OwnershipControlsRule.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.OwnershipControlsRule
      .builder()
      .objectOwnership(objectOwnership.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.OwnershipControlsRule.ReadOnly =
    zio.aws.s3.model.OwnershipControlsRule.wrap(buildAwsValue())
}
object OwnershipControlsRule {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.OwnershipControlsRule
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.OwnershipControlsRule =
      zio.aws.s3.model.OwnershipControlsRule(objectOwnership)
    def objectOwnership: zio.aws.s3.model.ObjectOwnership
    def getObjectOwnership
        : ZIO[Any, Nothing, zio.aws.s3.model.ObjectOwnership] =
      ZIO.succeed(objectOwnership)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.OwnershipControlsRule
  ) extends zio.aws.s3.model.OwnershipControlsRule.ReadOnly {
    override val objectOwnership: zio.aws.s3.model.ObjectOwnership =
      zio.aws.s3.model.ObjectOwnership.wrap(impl.objectOwnership())
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.OwnershipControlsRule
  ): zio.aws.s3.model.OwnershipControlsRule.ReadOnly = new Wrapper(impl)
}
