package zio.aws.s3.model
import zio.aws.s3.model.primitives.{AccountId, BucketName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class PutBucketAccelerateConfigurationRequest(
    bucket: BucketName,
    accelerateConfiguration: zio.aws.s3.model.AccelerateConfiguration,
    expectedBucketOwner: Optional[AccountId] = Optional.Absent,
    checksumAlgorithm: Optional[zio.aws.s3.model.ChecksumAlgorithm] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.PutBucketAccelerateConfigurationRequest = {
    import PutBucketAccelerateConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.PutBucketAccelerateConfigurationRequest
      .builder()
      .bucket(BucketName.unwrap(bucket): java.lang.String)
      .accelerateConfiguration(accelerateConfiguration.buildAwsValue())
      .optionallyWith(
        expectedBucketOwner.map(value =>
          AccountId.unwrap(value): java.lang.String
        )
      )(_.expectedBucketOwner)
      .optionallyWith(checksumAlgorithm.map(value => value.unwrap))(
        _.checksumAlgorithm
      )
      .build()
  }
  def asReadOnly
      : zio.aws.s3.model.PutBucketAccelerateConfigurationRequest.ReadOnly =
    zio.aws.s3.model.PutBucketAccelerateConfigurationRequest
      .wrap(buildAwsValue())
}
object PutBucketAccelerateConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.PutBucketAccelerateConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.PutBucketAccelerateConfigurationRequest =
      zio.aws.s3.model.PutBucketAccelerateConfigurationRequest(
        bucket,
        accelerateConfiguration.asEditable,
        expectedBucketOwner.map(value => value),
        checksumAlgorithm.map(value => value)
      )
    def bucket: BucketName
    def accelerateConfiguration
        : zio.aws.s3.model.AccelerateConfiguration.ReadOnly
    def expectedBucketOwner: Optional[AccountId]
    def checksumAlgorithm: Optional[zio.aws.s3.model.ChecksumAlgorithm]
    def getBucket: ZIO[Any, Nothing, BucketName] = ZIO.succeed(bucket)
    def getAccelerateConfiguration
        : ZIO[Any, Nothing, zio.aws.s3.model.AccelerateConfiguration.ReadOnly] =
      ZIO.succeed(accelerateConfiguration)
    def getExpectedBucketOwner: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("expectedBucketOwner", expectedBucketOwner)
    def getChecksumAlgorithm
        : ZIO[Any, AwsError, zio.aws.s3.model.ChecksumAlgorithm] =
      AwsError.unwrapOptionField("checksumAlgorithm", checksumAlgorithm)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.PutBucketAccelerateConfigurationRequest
  ) extends zio.aws.s3.model.PutBucketAccelerateConfigurationRequest.ReadOnly {
    override val bucket: BucketName =
      zio.aws.s3.model.primitives.BucketName(impl.bucket())
    override val accelerateConfiguration
        : zio.aws.s3.model.AccelerateConfiguration.ReadOnly =
      zio.aws.s3.model.AccelerateConfiguration
        .wrap(impl.accelerateConfiguration())
    override val expectedBucketOwner: Optional[AccountId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.expectedBucketOwner())
        .map(value => zio.aws.s3.model.primitives.AccountId(value))
    override val checksumAlgorithm
        : Optional[zio.aws.s3.model.ChecksumAlgorithm] = zio.aws.core.internal
      .optionalFromNullable(impl.checksumAlgorithm())
      .map(value => zio.aws.s3.model.ChecksumAlgorithm.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.PutBucketAccelerateConfigurationRequest
  ): zio.aws.s3.model.PutBucketAccelerateConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
