package zio.aws.s3.model
import zio.aws.s3.model.primitives.{AccountId, MetricsId, BucketName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class PutBucketMetricsConfigurationRequest(
    bucket: BucketName,
    id: MetricsId,
    metricsConfiguration: zio.aws.s3.model.MetricsConfiguration,
    expectedBucketOwner: Optional[AccountId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.PutBucketMetricsConfigurationRequest = {
    import PutBucketMetricsConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.PutBucketMetricsConfigurationRequest
      .builder()
      .bucket(BucketName.unwrap(bucket): java.lang.String)
      .id(MetricsId.unwrap(id): java.lang.String)
      .metricsConfiguration(metricsConfiguration.buildAwsValue())
      .optionallyWith(
        expectedBucketOwner.map(value =>
          AccountId.unwrap(value): java.lang.String
        )
      )(_.expectedBucketOwner)
      .build()
  }
  def asReadOnly
      : zio.aws.s3.model.PutBucketMetricsConfigurationRequest.ReadOnly =
    zio.aws.s3.model.PutBucketMetricsConfigurationRequest.wrap(buildAwsValue())
}
object PutBucketMetricsConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.PutBucketMetricsConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.PutBucketMetricsConfigurationRequest =
      zio.aws.s3.model.PutBucketMetricsConfigurationRequest(
        bucket,
        id,
        metricsConfiguration.asEditable,
        expectedBucketOwner.map(value => value)
      )
    def bucket: BucketName
    def id: MetricsId
    def metricsConfiguration: zio.aws.s3.model.MetricsConfiguration.ReadOnly
    def expectedBucketOwner: Optional[AccountId]
    def getBucket: ZIO[Any, Nothing, BucketName] = ZIO.succeed(bucket)
    def getId: ZIO[Any, Nothing, MetricsId] = ZIO.succeed(id)
    def getMetricsConfiguration
        : ZIO[Any, Nothing, zio.aws.s3.model.MetricsConfiguration.ReadOnly] =
      ZIO.succeed(metricsConfiguration)
    def getExpectedBucketOwner: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("expectedBucketOwner", expectedBucketOwner)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.PutBucketMetricsConfigurationRequest
  ) extends zio.aws.s3.model.PutBucketMetricsConfigurationRequest.ReadOnly {
    override val bucket: BucketName =
      zio.aws.s3.model.primitives.BucketName(impl.bucket())
    override val id: MetricsId =
      zio.aws.s3.model.primitives.MetricsId(impl.id())
    override val metricsConfiguration
        : zio.aws.s3.model.MetricsConfiguration.ReadOnly =
      zio.aws.s3.model.MetricsConfiguration.wrap(impl.metricsConfiguration())
    override val expectedBucketOwner: Optional[AccountId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.expectedBucketOwner())
        .map(value => zio.aws.s3.model.primitives.AccountId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.PutBucketMetricsConfigurationRequest
  ): zio.aws.s3.model.PutBucketMetricsConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
