package zio.aws.s3.model
import zio.aws.s3.model.primitives.{SkipValidation, AccountId, BucketName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class PutBucketNotificationConfigurationRequest(
    bucket: BucketName,
    notificationConfiguration: zio.aws.s3.model.NotificationConfiguration,
    expectedBucketOwner: Optional[AccountId] = Optional.Absent,
    skipDestinationValidation: Optional[SkipValidation] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.PutBucketNotificationConfigurationRequest = {
    import PutBucketNotificationConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.PutBucketNotificationConfigurationRequest
      .builder()
      .bucket(BucketName.unwrap(bucket): java.lang.String)
      .notificationConfiguration(notificationConfiguration.buildAwsValue())
      .optionallyWith(
        expectedBucketOwner.map(value =>
          AccountId.unwrap(value): java.lang.String
        )
      )(_.expectedBucketOwner)
      .optionallyWith(
        skipDestinationValidation.map(value =>
          SkipValidation.unwrap(value): java.lang.Boolean
        )
      )(_.skipDestinationValidation)
      .build()
  }
  def asReadOnly
      : zio.aws.s3.model.PutBucketNotificationConfigurationRequest.ReadOnly =
    zio.aws.s3.model.PutBucketNotificationConfigurationRequest
      .wrap(buildAwsValue())
}
object PutBucketNotificationConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.PutBucketNotificationConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.PutBucketNotificationConfigurationRequest =
      zio.aws.s3.model.PutBucketNotificationConfigurationRequest(
        bucket,
        notificationConfiguration.asEditable,
        expectedBucketOwner.map(value => value),
        skipDestinationValidation.map(value => value)
      )
    def bucket: BucketName
    def notificationConfiguration
        : zio.aws.s3.model.NotificationConfiguration.ReadOnly
    def expectedBucketOwner: Optional[AccountId]
    def skipDestinationValidation: Optional[SkipValidation]
    def getBucket: ZIO[Any, Nothing, BucketName] = ZIO.succeed(bucket)
    def getNotificationConfiguration: ZIO[
      Any,
      Nothing,
      zio.aws.s3.model.NotificationConfiguration.ReadOnly
    ] = ZIO.succeed(notificationConfiguration)
    def getExpectedBucketOwner: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("expectedBucketOwner", expectedBucketOwner)
    def getSkipDestinationValidation: ZIO[Any, AwsError, SkipValidation] =
      AwsError.unwrapOptionField(
        "skipDestinationValidation",
        skipDestinationValidation
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.PutBucketNotificationConfigurationRequest
  ) extends zio.aws.s3.model.PutBucketNotificationConfigurationRequest.ReadOnly {
    override val bucket: BucketName =
      zio.aws.s3.model.primitives.BucketName(impl.bucket())
    override val notificationConfiguration
        : zio.aws.s3.model.NotificationConfiguration.ReadOnly =
      zio.aws.s3.model.NotificationConfiguration
        .wrap(impl.notificationConfiguration())
    override val expectedBucketOwner: Optional[AccountId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.expectedBucketOwner())
        .map(value => zio.aws.s3.model.primitives.AccountId(value))
    override val skipDestinationValidation: Optional[SkipValidation] =
      zio.aws.core.internal
        .optionalFromNullable(impl.skipDestinationValidation())
        .map(value => zio.aws.s3.model.primitives.SkipValidation(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.PutBucketNotificationConfigurationRequest
  ): zio.aws.s3.model.PutBucketNotificationConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
