package zio.aws.s3.model
import zio.aws.s3.model.primitives.{
  ContentMD5,
  AccountId,
  ConfirmRemoveSelfBucketAccess,
  Policy,
  BucketName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class PutBucketPolicyRequest(
    bucket: BucketName,
    contentMD5: Optional[ContentMD5] = Optional.Absent,
    checksumAlgorithm: Optional[zio.aws.s3.model.ChecksumAlgorithm] =
      Optional.Absent,
    confirmRemoveSelfBucketAccess: Optional[ConfirmRemoveSelfBucketAccess] =
      Optional.Absent,
    policy: Policy,
    expectedBucketOwner: Optional[AccountId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.PutBucketPolicyRequest = {
    import PutBucketPolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.PutBucketPolicyRequest
      .builder()
      .bucket(BucketName.unwrap(bucket): java.lang.String)
      .optionallyWith(
        contentMD5.map(value => ContentMD5.unwrap(value): java.lang.String)
      )(_.contentMD5)
      .optionallyWith(checksumAlgorithm.map(value => value.unwrap))(
        _.checksumAlgorithm
      )
      .optionallyWith(
        confirmRemoveSelfBucketAccess.map(value =>
          ConfirmRemoveSelfBucketAccess.unwrap(value): java.lang.Boolean
        )
      )(_.confirmRemoveSelfBucketAccess)
      .policy(Policy.unwrap(policy): java.lang.String)
      .optionallyWith(
        expectedBucketOwner.map(value =>
          AccountId.unwrap(value): java.lang.String
        )
      )(_.expectedBucketOwner)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.PutBucketPolicyRequest.ReadOnly =
    zio.aws.s3.model.PutBucketPolicyRequest.wrap(buildAwsValue())
}
object PutBucketPolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.PutBucketPolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.PutBucketPolicyRequest =
      zio.aws.s3.model.PutBucketPolicyRequest(
        bucket,
        contentMD5.map(value => value),
        checksumAlgorithm.map(value => value),
        confirmRemoveSelfBucketAccess.map(value => value),
        policy,
        expectedBucketOwner.map(value => value)
      )
    def bucket: BucketName
    def contentMD5: Optional[ContentMD5]
    def checksumAlgorithm: Optional[zio.aws.s3.model.ChecksumAlgorithm]
    def confirmRemoveSelfBucketAccess: Optional[ConfirmRemoveSelfBucketAccess]
    def policy: Policy
    def expectedBucketOwner: Optional[AccountId]
    def getBucket: ZIO[Any, Nothing, BucketName] = ZIO.succeed(bucket)
    def getContentMD5: ZIO[Any, AwsError, ContentMD5] =
      AwsError.unwrapOptionField("contentMD5", contentMD5)
    def getChecksumAlgorithm
        : ZIO[Any, AwsError, zio.aws.s3.model.ChecksumAlgorithm] =
      AwsError.unwrapOptionField("checksumAlgorithm", checksumAlgorithm)
    def getConfirmRemoveSelfBucketAccess
        : ZIO[Any, AwsError, ConfirmRemoveSelfBucketAccess] =
      AwsError.unwrapOptionField(
        "confirmRemoveSelfBucketAccess",
        confirmRemoveSelfBucketAccess
      )
    def getPolicy: ZIO[Any, Nothing, Policy] = ZIO.succeed(policy)
    def getExpectedBucketOwner: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("expectedBucketOwner", expectedBucketOwner)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.PutBucketPolicyRequest
  ) extends zio.aws.s3.model.PutBucketPolicyRequest.ReadOnly {
    override val bucket: BucketName =
      zio.aws.s3.model.primitives.BucketName(impl.bucket())
    override val contentMD5: Optional[ContentMD5] = zio.aws.core.internal
      .optionalFromNullable(impl.contentMD5())
      .map(value => zio.aws.s3.model.primitives.ContentMD5(value))
    override val checksumAlgorithm
        : Optional[zio.aws.s3.model.ChecksumAlgorithm] = zio.aws.core.internal
      .optionalFromNullable(impl.checksumAlgorithm())
      .map(value => zio.aws.s3.model.ChecksumAlgorithm.wrap(value))
    override val confirmRemoveSelfBucketAccess
        : Optional[ConfirmRemoveSelfBucketAccess] = zio.aws.core.internal
      .optionalFromNullable(impl.confirmRemoveSelfBucketAccess())
      .map(value =>
        zio.aws.s3.model.primitives.ConfirmRemoveSelfBucketAccess(value)
      )
    override val policy: Policy =
      zio.aws.s3.model.primitives.Policy(impl.policy())
    override val expectedBucketOwner: Optional[AccountId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.expectedBucketOwner())
        .map(value => zio.aws.s3.model.primitives.AccountId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.PutBucketPolicyRequest
  ): zio.aws.s3.model.PutBucketPolicyRequest.ReadOnly = new Wrapper(impl)
}
