package zio.aws.s3.model
import zio.aws.s3.model.primitives.{
  ContentMD5,
  GrantRead,
  GrantReadACP,
  AccountId,
  ObjectKey,
  GrantWriteACP,
  GrantFullControl,
  BucketName,
  ObjectVersionId,
  GrantWrite
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class PutObjectAclRequest(
    acl: Optional[zio.aws.s3.model.ObjectCannedACL] = Optional.Absent,
    accessControlPolicy: Optional[zio.aws.s3.model.AccessControlPolicy] =
      Optional.Absent,
    bucket: BucketName,
    contentMD5: Optional[ContentMD5] = Optional.Absent,
    checksumAlgorithm: Optional[zio.aws.s3.model.ChecksumAlgorithm] =
      Optional.Absent,
    grantFullControl: Optional[GrantFullControl] = Optional.Absent,
    grantRead: Optional[GrantRead] = Optional.Absent,
    grantReadACP: Optional[GrantReadACP] = Optional.Absent,
    grantWrite: Optional[GrantWrite] = Optional.Absent,
    grantWriteACP: Optional[GrantWriteACP] = Optional.Absent,
    key: ObjectKey,
    requestPayer: Optional[zio.aws.s3.model.RequestPayer] = Optional.Absent,
    versionId: Optional[ObjectVersionId] = Optional.Absent,
    expectedBucketOwner: Optional[AccountId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.PutObjectAclRequest = {
    import PutObjectAclRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.PutObjectAclRequest
      .builder()
      .optionallyWith(acl.map(value => value.unwrap))(_.acl)
      .optionallyWith(accessControlPolicy.map(value => value.buildAwsValue()))(
        _.accessControlPolicy
      )
      .bucket(BucketName.unwrap(bucket): java.lang.String)
      .optionallyWith(
        contentMD5.map(value => ContentMD5.unwrap(value): java.lang.String)
      )(_.contentMD5)
      .optionallyWith(checksumAlgorithm.map(value => value.unwrap))(
        _.checksumAlgorithm
      )
      .optionallyWith(
        grantFullControl.map(value =>
          GrantFullControl.unwrap(value): java.lang.String
        )
      )(_.grantFullControl)
      .optionallyWith(
        grantRead.map(value => GrantRead.unwrap(value): java.lang.String)
      )(_.grantRead)
      .optionallyWith(
        grantReadACP.map(value => GrantReadACP.unwrap(value): java.lang.String)
      )(_.grantReadACP)
      .optionallyWith(
        grantWrite.map(value => GrantWrite.unwrap(value): java.lang.String)
      )(_.grantWrite)
      .optionallyWith(
        grantWriteACP.map(value =>
          GrantWriteACP.unwrap(value): java.lang.String
        )
      )(_.grantWriteACP)
      .key(ObjectKey.unwrap(key): java.lang.String)
      .optionallyWith(requestPayer.map(value => value.unwrap))(_.requestPayer)
      .optionallyWith(
        versionId.map(value => ObjectVersionId.unwrap(value): java.lang.String)
      )(_.versionId)
      .optionallyWith(
        expectedBucketOwner.map(value =>
          AccountId.unwrap(value): java.lang.String
        )
      )(_.expectedBucketOwner)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.PutObjectAclRequest.ReadOnly =
    zio.aws.s3.model.PutObjectAclRequest.wrap(buildAwsValue())
}
object PutObjectAclRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.PutObjectAclRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.PutObjectAclRequest =
      zio.aws.s3.model.PutObjectAclRequest(
        acl.map(value => value),
        accessControlPolicy.map(value => value.asEditable),
        bucket,
        contentMD5.map(value => value),
        checksumAlgorithm.map(value => value),
        grantFullControl.map(value => value),
        grantRead.map(value => value),
        grantReadACP.map(value => value),
        grantWrite.map(value => value),
        grantWriteACP.map(value => value),
        key,
        requestPayer.map(value => value),
        versionId.map(value => value),
        expectedBucketOwner.map(value => value)
      )
    def acl: Optional[zio.aws.s3.model.ObjectCannedACL]
    def accessControlPolicy
        : Optional[zio.aws.s3.model.AccessControlPolicy.ReadOnly]
    def bucket: BucketName
    def contentMD5: Optional[ContentMD5]
    def checksumAlgorithm: Optional[zio.aws.s3.model.ChecksumAlgorithm]
    def grantFullControl: Optional[GrantFullControl]
    def grantRead: Optional[GrantRead]
    def grantReadACP: Optional[GrantReadACP]
    def grantWrite: Optional[GrantWrite]
    def grantWriteACP: Optional[GrantWriteACP]
    def key: ObjectKey
    def requestPayer: Optional[zio.aws.s3.model.RequestPayer]
    def versionId: Optional[ObjectVersionId]
    def expectedBucketOwner: Optional[AccountId]
    def getAcl: ZIO[Any, AwsError, zio.aws.s3.model.ObjectCannedACL] =
      AwsError.unwrapOptionField("acl", acl)
    def getAccessControlPolicy
        : ZIO[Any, AwsError, zio.aws.s3.model.AccessControlPolicy.ReadOnly] =
      AwsError.unwrapOptionField("accessControlPolicy", accessControlPolicy)
    def getBucket: ZIO[Any, Nothing, BucketName] = ZIO.succeed(bucket)
    def getContentMD5: ZIO[Any, AwsError, ContentMD5] =
      AwsError.unwrapOptionField("contentMD5", contentMD5)
    def getChecksumAlgorithm
        : ZIO[Any, AwsError, zio.aws.s3.model.ChecksumAlgorithm] =
      AwsError.unwrapOptionField("checksumAlgorithm", checksumAlgorithm)
    def getGrantFullControl: ZIO[Any, AwsError, GrantFullControl] =
      AwsError.unwrapOptionField("grantFullControl", grantFullControl)
    def getGrantRead: ZIO[Any, AwsError, GrantRead] =
      AwsError.unwrapOptionField("grantRead", grantRead)
    def getGrantReadACP: ZIO[Any, AwsError, GrantReadACP] =
      AwsError.unwrapOptionField("grantReadACP", grantReadACP)
    def getGrantWrite: ZIO[Any, AwsError, GrantWrite] =
      AwsError.unwrapOptionField("grantWrite", grantWrite)
    def getGrantWriteACP: ZIO[Any, AwsError, GrantWriteACP] =
      AwsError.unwrapOptionField("grantWriteACP", grantWriteACP)
    def getKey: ZIO[Any, Nothing, ObjectKey] = ZIO.succeed(key)
    def getRequestPayer: ZIO[Any, AwsError, zio.aws.s3.model.RequestPayer] =
      AwsError.unwrapOptionField("requestPayer", requestPayer)
    def getVersionId: ZIO[Any, AwsError, ObjectVersionId] =
      AwsError.unwrapOptionField("versionId", versionId)
    def getExpectedBucketOwner: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("expectedBucketOwner", expectedBucketOwner)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.PutObjectAclRequest
  ) extends zio.aws.s3.model.PutObjectAclRequest.ReadOnly {
    override val acl: Optional[zio.aws.s3.model.ObjectCannedACL] =
      zio.aws.core.internal
        .optionalFromNullable(impl.acl())
        .map(value => zio.aws.s3.model.ObjectCannedACL.wrap(value))
    override val accessControlPolicy
        : Optional[zio.aws.s3.model.AccessControlPolicy.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.accessControlPolicy())
        .map(value => zio.aws.s3.model.AccessControlPolicy.wrap(value))
    override val bucket: BucketName =
      zio.aws.s3.model.primitives.BucketName(impl.bucket())
    override val contentMD5: Optional[ContentMD5] = zio.aws.core.internal
      .optionalFromNullable(impl.contentMD5())
      .map(value => zio.aws.s3.model.primitives.ContentMD5(value))
    override val checksumAlgorithm
        : Optional[zio.aws.s3.model.ChecksumAlgorithm] = zio.aws.core.internal
      .optionalFromNullable(impl.checksumAlgorithm())
      .map(value => zio.aws.s3.model.ChecksumAlgorithm.wrap(value))
    override val grantFullControl: Optional[GrantFullControl] =
      zio.aws.core.internal
        .optionalFromNullable(impl.grantFullControl())
        .map(value => zio.aws.s3.model.primitives.GrantFullControl(value))
    override val grantRead: Optional[GrantRead] = zio.aws.core.internal
      .optionalFromNullable(impl.grantRead())
      .map(value => zio.aws.s3.model.primitives.GrantRead(value))
    override val grantReadACP: Optional[GrantReadACP] = zio.aws.core.internal
      .optionalFromNullable(impl.grantReadACP())
      .map(value => zio.aws.s3.model.primitives.GrantReadACP(value))
    override val grantWrite: Optional[GrantWrite] = zio.aws.core.internal
      .optionalFromNullable(impl.grantWrite())
      .map(value => zio.aws.s3.model.primitives.GrantWrite(value))
    override val grantWriteACP: Optional[GrantWriteACP] = zio.aws.core.internal
      .optionalFromNullable(impl.grantWriteACP())
      .map(value => zio.aws.s3.model.primitives.GrantWriteACP(value))
    override val key: ObjectKey =
      zio.aws.s3.model.primitives.ObjectKey(impl.key())
    override val requestPayer: Optional[zio.aws.s3.model.RequestPayer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.requestPayer())
        .map(value => zio.aws.s3.model.RequestPayer.wrap(value))
    override val versionId: Optional[ObjectVersionId] = zio.aws.core.internal
      .optionalFromNullable(impl.versionId())
      .map(value => zio.aws.s3.model.primitives.ObjectVersionId(value))
    override val expectedBucketOwner: Optional[AccountId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.expectedBucketOwner())
        .map(value => zio.aws.s3.model.primitives.AccountId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.PutObjectAclRequest
  ): zio.aws.s3.model.PutObjectAclRequest.ReadOnly = new Wrapper(impl)
}
