package zio.aws.s3.model
import zio.aws.s3.model.primitives.{
  ETag,
  Expiration,
  SSECustomerAlgorithm,
  SSECustomerKeyMD5,
  SSEKMSEncryptionContext,
  ChecksumSHA256,
  ChecksumCRC32C,
  ChecksumCRC32,
  ChecksumSHA1,
  SSEKMSKeyId,
  ObjectVersionId,
  BucketKeyEnabled
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class PutObjectResponse(
    expiration: Optional[Expiration] = Optional.Absent,
    eTag: Optional[ETag] = Optional.Absent,
    checksumCRC32: Optional[ChecksumCRC32] = Optional.Absent,
    checksumCRC32C: Optional[ChecksumCRC32C] = Optional.Absent,
    checksumSHA1: Optional[ChecksumSHA1] = Optional.Absent,
    checksumSHA256: Optional[ChecksumSHA256] = Optional.Absent,
    serverSideEncryption: Optional[zio.aws.s3.model.ServerSideEncryption] =
      Optional.Absent,
    versionId: Optional[ObjectVersionId] = Optional.Absent,
    sseCustomerAlgorithm: Optional[SSECustomerAlgorithm] = Optional.Absent,
    sseCustomerKeyMD5: Optional[SSECustomerKeyMD5] = Optional.Absent,
    ssekmsKeyId: Optional[SSEKMSKeyId] = Optional.Absent,
    ssekmsEncryptionContext: Optional[SSEKMSEncryptionContext] =
      Optional.Absent,
    bucketKeyEnabled: Optional[BucketKeyEnabled] = Optional.Absent,
    requestCharged: Optional[zio.aws.s3.model.RequestCharged] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.PutObjectResponse = {
    import PutObjectResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.PutObjectResponse
      .builder()
      .optionallyWith(
        expiration.map(value => Expiration.unwrap(value): java.lang.String)
      )(_.expiration)
      .optionallyWith(eTag.map(value => ETag.unwrap(value): java.lang.String))(
        _.eTag
      )
      .optionallyWith(
        checksumCRC32.map(value =>
          ChecksumCRC32.unwrap(value): java.lang.String
        )
      )(_.checksumCRC32)
      .optionallyWith(
        checksumCRC32C.map(value =>
          ChecksumCRC32C.unwrap(value): java.lang.String
        )
      )(_.checksumCRC32C)
      .optionallyWith(
        checksumSHA1.map(value => ChecksumSHA1.unwrap(value): java.lang.String)
      )(_.checksumSHA1)
      .optionallyWith(
        checksumSHA256.map(value =>
          ChecksumSHA256.unwrap(value): java.lang.String
        )
      )(_.checksumSHA256)
      .optionallyWith(serverSideEncryption.map(value => value.unwrap))(
        _.serverSideEncryption
      )
      .optionallyWith(
        versionId.map(value => ObjectVersionId.unwrap(value): java.lang.String)
      )(_.versionId)
      .optionallyWith(
        sseCustomerAlgorithm.map(value =>
          SSECustomerAlgorithm.unwrap(value): java.lang.String
        )
      )(_.sseCustomerAlgorithm)
      .optionallyWith(
        sseCustomerKeyMD5.map(value =>
          SSECustomerKeyMD5.unwrap(value): java.lang.String
        )
      )(_.sseCustomerKeyMD5)
      .optionallyWith(
        ssekmsKeyId.map(value => SSEKMSKeyId.unwrap(value): java.lang.String)
      )(_.ssekmsKeyId)
      .optionallyWith(
        ssekmsEncryptionContext.map(value =>
          SSEKMSEncryptionContext.unwrap(value): java.lang.String
        )
      )(_.ssekmsEncryptionContext)
      .optionallyWith(
        bucketKeyEnabled.map(value =>
          BucketKeyEnabled.unwrap(value): java.lang.Boolean
        )
      )(_.bucketKeyEnabled)
      .optionallyWith(requestCharged.map(value => value.unwrap))(
        _.requestCharged
      )
      .build()
  }
  def asReadOnly: zio.aws.s3.model.PutObjectResponse.ReadOnly =
    zio.aws.s3.model.PutObjectResponse.wrap(buildAwsValue())
}
object PutObjectResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.PutObjectResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.PutObjectResponse =
      zio.aws.s3.model.PutObjectResponse(
        expiration.map(value => value),
        eTag.map(value => value),
        checksumCRC32.map(value => value),
        checksumCRC32C.map(value => value),
        checksumSHA1.map(value => value),
        checksumSHA256.map(value => value),
        serverSideEncryption.map(value => value),
        versionId.map(value => value),
        sseCustomerAlgorithm.map(value => value),
        sseCustomerKeyMD5.map(value => value),
        ssekmsKeyId.map(value => value),
        ssekmsEncryptionContext.map(value => value),
        bucketKeyEnabled.map(value => value),
        requestCharged.map(value => value)
      )
    def expiration: Optional[Expiration]
    def eTag: Optional[ETag]
    def checksumCRC32: Optional[ChecksumCRC32]
    def checksumCRC32C: Optional[ChecksumCRC32C]
    def checksumSHA1: Optional[ChecksumSHA1]
    def checksumSHA256: Optional[ChecksumSHA256]
    def serverSideEncryption: Optional[zio.aws.s3.model.ServerSideEncryption]
    def versionId: Optional[ObjectVersionId]
    def sseCustomerAlgorithm: Optional[SSECustomerAlgorithm]
    def sseCustomerKeyMD5: Optional[SSECustomerKeyMD5]
    def ssekmsKeyId: Optional[SSEKMSKeyId]
    def ssekmsEncryptionContext: Optional[SSEKMSEncryptionContext]
    def bucketKeyEnabled: Optional[BucketKeyEnabled]
    def requestCharged: Optional[zio.aws.s3.model.RequestCharged]
    def getExpiration: ZIO[Any, AwsError, Expiration] =
      AwsError.unwrapOptionField("expiration", expiration)
    def getETag: ZIO[Any, AwsError, ETag] =
      AwsError.unwrapOptionField("eTag", eTag)
    def getChecksumCRC32: ZIO[Any, AwsError, ChecksumCRC32] =
      AwsError.unwrapOptionField("checksumCRC32", checksumCRC32)
    def getChecksumCRC32C: ZIO[Any, AwsError, ChecksumCRC32C] =
      AwsError.unwrapOptionField("checksumCRC32C", checksumCRC32C)
    def getChecksumSHA1: ZIO[Any, AwsError, ChecksumSHA1] =
      AwsError.unwrapOptionField("checksumSHA1", checksumSHA1)
    def getChecksumSHA256: ZIO[Any, AwsError, ChecksumSHA256] =
      AwsError.unwrapOptionField("checksumSHA256", checksumSHA256)
    def getServerSideEncryption
        : ZIO[Any, AwsError, zio.aws.s3.model.ServerSideEncryption] =
      AwsError.unwrapOptionField("serverSideEncryption", serverSideEncryption)
    def getVersionId: ZIO[Any, AwsError, ObjectVersionId] =
      AwsError.unwrapOptionField("versionId", versionId)
    def getSseCustomerAlgorithm: ZIO[Any, AwsError, SSECustomerAlgorithm] =
      AwsError.unwrapOptionField("sseCustomerAlgorithm", sseCustomerAlgorithm)
    def getSseCustomerKeyMD5: ZIO[Any, AwsError, SSECustomerKeyMD5] =
      AwsError.unwrapOptionField("sseCustomerKeyMD5", sseCustomerKeyMD5)
    def getSsekmsKeyId: ZIO[Any, AwsError, SSEKMSKeyId] =
      AwsError.unwrapOptionField("ssekmsKeyId", ssekmsKeyId)
    def getSsekmsEncryptionContext
        : ZIO[Any, AwsError, SSEKMSEncryptionContext] = AwsError
      .unwrapOptionField("ssekmsEncryptionContext", ssekmsEncryptionContext)
    def getBucketKeyEnabled: ZIO[Any, AwsError, BucketKeyEnabled] =
      AwsError.unwrapOptionField("bucketKeyEnabled", bucketKeyEnabled)
    def getRequestCharged: ZIO[Any, AwsError, zio.aws.s3.model.RequestCharged] =
      AwsError.unwrapOptionField("requestCharged", requestCharged)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.PutObjectResponse
  ) extends zio.aws.s3.model.PutObjectResponse.ReadOnly {
    override val expiration: Optional[Expiration] = zio.aws.core.internal
      .optionalFromNullable(impl.expiration())
      .map(value => zio.aws.s3.model.primitives.Expiration(value))
    override val eTag: Optional[ETag] = zio.aws.core.internal
      .optionalFromNullable(impl.eTag())
      .map(value => zio.aws.s3.model.primitives.ETag(value))
    override val checksumCRC32: Optional[ChecksumCRC32] = zio.aws.core.internal
      .optionalFromNullable(impl.checksumCRC32())
      .map(value => zio.aws.s3.model.primitives.ChecksumCRC32(value))
    override val checksumCRC32C: Optional[ChecksumCRC32C] =
      zio.aws.core.internal
        .optionalFromNullable(impl.checksumCRC32C())
        .map(value => zio.aws.s3.model.primitives.ChecksumCRC32C(value))
    override val checksumSHA1: Optional[ChecksumSHA1] = zio.aws.core.internal
      .optionalFromNullable(impl.checksumSHA1())
      .map(value => zio.aws.s3.model.primitives.ChecksumSHA1(value))
    override val checksumSHA256: Optional[ChecksumSHA256] =
      zio.aws.core.internal
        .optionalFromNullable(impl.checksumSHA256())
        .map(value => zio.aws.s3.model.primitives.ChecksumSHA256(value))
    override val serverSideEncryption
        : Optional[zio.aws.s3.model.ServerSideEncryption] =
      zio.aws.core.internal
        .optionalFromNullable(impl.serverSideEncryption())
        .map(value => zio.aws.s3.model.ServerSideEncryption.wrap(value))
    override val versionId: Optional[ObjectVersionId] = zio.aws.core.internal
      .optionalFromNullable(impl.versionId())
      .map(value => zio.aws.s3.model.primitives.ObjectVersionId(value))
    override val sseCustomerAlgorithm: Optional[SSECustomerAlgorithm] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sseCustomerAlgorithm())
        .map(value => zio.aws.s3.model.primitives.SSECustomerAlgorithm(value))
    override val sseCustomerKeyMD5: Optional[SSECustomerKeyMD5] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sseCustomerKeyMD5())
        .map(value => zio.aws.s3.model.primitives.SSECustomerKeyMD5(value))
    override val ssekmsKeyId: Optional[SSEKMSKeyId] = zio.aws.core.internal
      .optionalFromNullable(impl.ssekmsKeyId())
      .map(value => zio.aws.s3.model.primitives.SSEKMSKeyId(value))
    override val ssekmsEncryptionContext: Optional[SSEKMSEncryptionContext] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ssekmsEncryptionContext())
        .map(value =>
          zio.aws.s3.model.primitives.SSEKMSEncryptionContext(value)
        )
    override val bucketKeyEnabled: Optional[BucketKeyEnabled] =
      zio.aws.core.internal
        .optionalFromNullable(impl.bucketKeyEnabled())
        .map(value => zio.aws.s3.model.primitives.BucketKeyEnabled(value))
    override val requestCharged: Optional[zio.aws.s3.model.RequestCharged] =
      zio.aws.core.internal
        .optionalFromNullable(impl.requestCharged())
        .map(value => zio.aws.s3.model.RequestCharged.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.PutObjectResponse
  ): zio.aws.s3.model.PutObjectResponse.ReadOnly = new Wrapper(impl)
}
