package zio.aws.s3.model
import zio.aws.s3.model.primitives.{
  ContentMD5,
  BypassGovernanceRetention,
  AccountId,
  ObjectKey,
  BucketName,
  ObjectVersionId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class PutObjectRetentionRequest(
    bucket: BucketName,
    key: ObjectKey,
    retention: Optional[zio.aws.s3.model.ObjectLockRetention] = Optional.Absent,
    requestPayer: Optional[zio.aws.s3.model.RequestPayer] = Optional.Absent,
    versionId: Optional[ObjectVersionId] = Optional.Absent,
    bypassGovernanceRetention: Optional[BypassGovernanceRetention] =
      Optional.Absent,
    contentMD5: Optional[ContentMD5] = Optional.Absent,
    checksumAlgorithm: Optional[zio.aws.s3.model.ChecksumAlgorithm] =
      Optional.Absent,
    expectedBucketOwner: Optional[AccountId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.PutObjectRetentionRequest = {
    import PutObjectRetentionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.PutObjectRetentionRequest
      .builder()
      .bucket(BucketName.unwrap(bucket): java.lang.String)
      .key(ObjectKey.unwrap(key): java.lang.String)
      .optionallyWith(retention.map(value => value.buildAwsValue()))(
        _.retention
      )
      .optionallyWith(requestPayer.map(value => value.unwrap))(_.requestPayer)
      .optionallyWith(
        versionId.map(value => ObjectVersionId.unwrap(value): java.lang.String)
      )(_.versionId)
      .optionallyWith(
        bypassGovernanceRetention.map(value =>
          BypassGovernanceRetention.unwrap(value): java.lang.Boolean
        )
      )(_.bypassGovernanceRetention)
      .optionallyWith(
        contentMD5.map(value => ContentMD5.unwrap(value): java.lang.String)
      )(_.contentMD5)
      .optionallyWith(checksumAlgorithm.map(value => value.unwrap))(
        _.checksumAlgorithm
      )
      .optionallyWith(
        expectedBucketOwner.map(value =>
          AccountId.unwrap(value): java.lang.String
        )
      )(_.expectedBucketOwner)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.PutObjectRetentionRequest.ReadOnly =
    zio.aws.s3.model.PutObjectRetentionRequest.wrap(buildAwsValue())
}
object PutObjectRetentionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.PutObjectRetentionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.PutObjectRetentionRequest =
      zio.aws.s3.model.PutObjectRetentionRequest(
        bucket,
        key,
        retention.map(value => value.asEditable),
        requestPayer.map(value => value),
        versionId.map(value => value),
        bypassGovernanceRetention.map(value => value),
        contentMD5.map(value => value),
        checksumAlgorithm.map(value => value),
        expectedBucketOwner.map(value => value)
      )
    def bucket: BucketName
    def key: ObjectKey
    def retention: Optional[zio.aws.s3.model.ObjectLockRetention.ReadOnly]
    def requestPayer: Optional[zio.aws.s3.model.RequestPayer]
    def versionId: Optional[ObjectVersionId]
    def bypassGovernanceRetention: Optional[BypassGovernanceRetention]
    def contentMD5: Optional[ContentMD5]
    def checksumAlgorithm: Optional[zio.aws.s3.model.ChecksumAlgorithm]
    def expectedBucketOwner: Optional[AccountId]
    def getBucket: ZIO[Any, Nothing, BucketName] = ZIO.succeed(bucket)
    def getKey: ZIO[Any, Nothing, ObjectKey] = ZIO.succeed(key)
    def getRetention
        : ZIO[Any, AwsError, zio.aws.s3.model.ObjectLockRetention.ReadOnly] =
      AwsError.unwrapOptionField("retention", retention)
    def getRequestPayer: ZIO[Any, AwsError, zio.aws.s3.model.RequestPayer] =
      AwsError.unwrapOptionField("requestPayer", requestPayer)
    def getVersionId: ZIO[Any, AwsError, ObjectVersionId] =
      AwsError.unwrapOptionField("versionId", versionId)
    def getBypassGovernanceRetention
        : ZIO[Any, AwsError, BypassGovernanceRetention] = AwsError
      .unwrapOptionField("bypassGovernanceRetention", bypassGovernanceRetention)
    def getContentMD5: ZIO[Any, AwsError, ContentMD5] =
      AwsError.unwrapOptionField("contentMD5", contentMD5)
    def getChecksumAlgorithm
        : ZIO[Any, AwsError, zio.aws.s3.model.ChecksumAlgorithm] =
      AwsError.unwrapOptionField("checksumAlgorithm", checksumAlgorithm)
    def getExpectedBucketOwner: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("expectedBucketOwner", expectedBucketOwner)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.PutObjectRetentionRequest
  ) extends zio.aws.s3.model.PutObjectRetentionRequest.ReadOnly {
    override val bucket: BucketName =
      zio.aws.s3.model.primitives.BucketName(impl.bucket())
    override val key: ObjectKey =
      zio.aws.s3.model.primitives.ObjectKey(impl.key())
    override val retention
        : Optional[zio.aws.s3.model.ObjectLockRetention.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.retention())
        .map(value => zio.aws.s3.model.ObjectLockRetention.wrap(value))
    override val requestPayer: Optional[zio.aws.s3.model.RequestPayer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.requestPayer())
        .map(value => zio.aws.s3.model.RequestPayer.wrap(value))
    override val versionId: Optional[ObjectVersionId] = zio.aws.core.internal
      .optionalFromNullable(impl.versionId())
      .map(value => zio.aws.s3.model.primitives.ObjectVersionId(value))
    override val bypassGovernanceRetention
        : Optional[BypassGovernanceRetention] = zio.aws.core.internal
      .optionalFromNullable(impl.bypassGovernanceRetention())
      .map(value =>
        zio.aws.s3.model.primitives.BypassGovernanceRetention(value)
      )
    override val contentMD5: Optional[ContentMD5] = zio.aws.core.internal
      .optionalFromNullable(impl.contentMD5())
      .map(value => zio.aws.s3.model.primitives.ContentMD5(value))
    override val checksumAlgorithm
        : Optional[zio.aws.s3.model.ChecksumAlgorithm] = zio.aws.core.internal
      .optionalFromNullable(impl.checksumAlgorithm())
      .map(value => zio.aws.s3.model.ChecksumAlgorithm.wrap(value))
    override val expectedBucketOwner: Optional[AccountId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.expectedBucketOwner())
        .map(value => zio.aws.s3.model.primitives.AccountId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.PutObjectRetentionRequest
  ): zio.aws.s3.model.PutObjectRetentionRequest.ReadOnly = new Wrapper(impl)
}
