package zio.aws.s3.model
import zio.aws.s3.model.primitives.{QueueArn, NotificationId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class QueueConfiguration(
    id: Optional[NotificationId] = Optional.Absent,
    queueArn: QueueArn,
    events: Iterable[zio.aws.s3.model.Event],
    filter: Optional[zio.aws.s3.model.NotificationConfigurationFilter] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.QueueConfiguration = {
    import QueueConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.QueueConfiguration
      .builder()
      .optionallyWith(
        id.map(value => NotificationId.unwrap(value): java.lang.String)
      )(_.id)
      .queueArn(QueueArn.unwrap(queueArn): java.lang.String)
      .eventsWithStrings(events.map { item =>
        item.unwrap.toString
      }.asJavaCollection)
      .optionallyWith(filter.map(value => value.buildAwsValue()))(_.filter)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.QueueConfiguration.ReadOnly =
    zio.aws.s3.model.QueueConfiguration.wrap(buildAwsValue())
}
object QueueConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.QueueConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.QueueConfiguration =
      zio.aws.s3.model.QueueConfiguration(
        id.map(value => value),
        queueArn,
        events,
        filter.map(value => value.asEditable)
      )
    def id: Optional[NotificationId]
    def queueArn: QueueArn
    def events: List[zio.aws.s3.model.Event]
    def filter
        : Optional[zio.aws.s3.model.NotificationConfigurationFilter.ReadOnly]
    def getId: ZIO[Any, AwsError, NotificationId] =
      AwsError.unwrapOptionField("id", id)
    def getQueueArn: ZIO[Any, Nothing, QueueArn] = ZIO.succeed(queueArn)
    def getEvents: ZIO[Any, Nothing, List[zio.aws.s3.model.Event]] =
      ZIO.succeed(events)
    def getFilter: ZIO[
      Any,
      AwsError,
      zio.aws.s3.model.NotificationConfigurationFilter.ReadOnly
    ] = AwsError.unwrapOptionField("filter", filter)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.QueueConfiguration
  ) extends zio.aws.s3.model.QueueConfiguration.ReadOnly {
    override val id: Optional[NotificationId] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.s3.model.primitives.NotificationId(value))
    override val queueArn: QueueArn =
      zio.aws.s3.model.primitives.QueueArn(impl.queueArn())
    override val events: List[zio.aws.s3.model.Event] = impl
      .events()
      .asScala
      .map { item =>
        zio.aws.s3.model.Event.wrap(item)
      }
      .toList
    override val filter
        : Optional[zio.aws.s3.model.NotificationConfigurationFilter.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filter())
        .map(value =>
          zio.aws.s3.model.NotificationConfigurationFilter.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.QueueConfiguration
  ): zio.aws.s3.model.QueueConfiguration.ReadOnly = new Wrapper(impl)
}
