package zio.aws.s3.model
import scala.jdk.CollectionConverters.*
sealed trait ReplicationStatus {
  def unwrap: software.amazon.awssdk.services.s3.model.ReplicationStatus
}
object ReplicationStatus {
  def wrap(
      value: software.amazon.awssdk.services.s3.model.ReplicationStatus
  ): zio.aws.s3.model.ReplicationStatus = value match {
    case software.amazon.awssdk.services.s3.model.ReplicationStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.s3.model.ReplicationStatus.COMPLETE =>
      val r = COMPLETE
      r
    case software.amazon.awssdk.services.s3.model.ReplicationStatus.PENDING =>
      val r = PENDING
      r
    case software.amazon.awssdk.services.s3.model.ReplicationStatus.FAILED =>
      val r = FAILED
      r
    case software.amazon.awssdk.services.s3.model.ReplicationStatus.REPLICA =>
      val r = REPLICA
      r
    case software.amazon.awssdk.services.s3.model.ReplicationStatus.COMPLETED =>
      val r = COMPLETED
      r
  }
  case object unknownToSdkVersion extends zio.aws.s3.model.ReplicationStatus {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.ReplicationStatus =
      software.amazon.awssdk.services.s3.model.ReplicationStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object COMPLETE extends zio.aws.s3.model.ReplicationStatus {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.ReplicationStatus =
      software.amazon.awssdk.services.s3.model.ReplicationStatus.COMPLETE
  }
  case object PENDING extends zio.aws.s3.model.ReplicationStatus {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.ReplicationStatus =
      software.amazon.awssdk.services.s3.model.ReplicationStatus.PENDING
  }
  case object FAILED extends zio.aws.s3.model.ReplicationStatus {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.ReplicationStatus =
      software.amazon.awssdk.services.s3.model.ReplicationStatus.FAILED
  }
  case object REPLICA extends zio.aws.s3.model.ReplicationStatus {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.ReplicationStatus =
      software.amazon.awssdk.services.s3.model.ReplicationStatus.REPLICA
  }
  case object COMPLETED extends zio.aws.s3.model.ReplicationStatus {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.ReplicationStatus =
      software.amazon.awssdk.services.s3.model.ReplicationStatus.COMPLETED
  }
}
