package zio.aws.s3.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class RequestPaymentConfiguration(payer: zio.aws.s3.model.Payer) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.RequestPaymentConfiguration = {
    import RequestPaymentConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.RequestPaymentConfiguration
      .builder()
      .payer(payer.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.RequestPaymentConfiguration.ReadOnly =
    zio.aws.s3.model.RequestPaymentConfiguration.wrap(buildAwsValue())
}
object RequestPaymentConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.RequestPaymentConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.RequestPaymentConfiguration =
      zio.aws.s3.model.RequestPaymentConfiguration(payer)
    def payer: zio.aws.s3.model.Payer
    def getPayer: ZIO[Any, Nothing, zio.aws.s3.model.Payer] = ZIO.succeed(payer)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.RequestPaymentConfiguration
  ) extends zio.aws.s3.model.RequestPaymentConfiguration.ReadOnly {
    override val payer: zio.aws.s3.model.Payer =
      zio.aws.s3.model.Payer.wrap(impl.payer())
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.RequestPaymentConfiguration
  ): zio.aws.s3.model.RequestPaymentConfiguration.ReadOnly = new Wrapper(impl)
}
