package zio.aws.s3.model
import scala.jdk.CollectionConverters.*
sealed trait RestoreRequestType {
  def unwrap: software.amazon.awssdk.services.s3.model.RestoreRequestType
}
object RestoreRequestType {
  def wrap(
      value: software.amazon.awssdk.services.s3.model.RestoreRequestType
  ): zio.aws.s3.model.RestoreRequestType = value match {
    case software.amazon.awssdk.services.s3.model.RestoreRequestType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.s3.model.RestoreRequestType.SELECT =>
      val r = SELECT
      r
  }
  case object unknownToSdkVersion extends zio.aws.s3.model.RestoreRequestType {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.RestoreRequestType =
      software.amazon.awssdk.services.s3.model.RestoreRequestType.UNKNOWN_TO_SDK_VERSION
  }
  case object SELECT extends zio.aws.s3.model.RestoreRequestType {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.RestoreRequestType =
      software.amazon.awssdk.services.s3.model.RestoreRequestType.SELECT
  }
}
