package zio.aws.s3.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.s3.model.primitives.{RestoreExpiryDate, IsRestoreInProgress}
import scala.jdk.CollectionConverters.*
final case class RestoreStatus(
    isRestoreInProgress: Optional[IsRestoreInProgress] = Optional.Absent,
    restoreExpiryDate: Optional[RestoreExpiryDate] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.RestoreStatus = {
    import RestoreStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.RestoreStatus
      .builder()
      .optionallyWith(
        isRestoreInProgress.map(value =>
          IsRestoreInProgress.unwrap(value): java.lang.Boolean
        )
      )(_.isRestoreInProgress)
      .optionallyWith(
        restoreExpiryDate.map(value => RestoreExpiryDate.unwrap(value): Instant)
      )(_.restoreExpiryDate)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.RestoreStatus.ReadOnly =
    zio.aws.s3.model.RestoreStatus.wrap(buildAwsValue())
}
object RestoreStatus {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.s3.model.RestoreStatus] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.RestoreStatus =
      zio.aws.s3.model.RestoreStatus(
        isRestoreInProgress.map(value => value),
        restoreExpiryDate.map(value => value)
      )
    def isRestoreInProgress: Optional[IsRestoreInProgress]
    def restoreExpiryDate: Optional[RestoreExpiryDate]
    def getIsRestoreInProgress: ZIO[Any, AwsError, IsRestoreInProgress] =
      AwsError.unwrapOptionField("isRestoreInProgress", isRestoreInProgress)
    def getRestoreExpiryDate: ZIO[Any, AwsError, RestoreExpiryDate] =
      AwsError.unwrapOptionField("restoreExpiryDate", restoreExpiryDate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.RestoreStatus
  ) extends zio.aws.s3.model.RestoreStatus.ReadOnly {
    override val isRestoreInProgress: Optional[IsRestoreInProgress] =
      zio.aws.core.internal
        .optionalFromNullable(impl.isRestoreInProgress())
        .map(value => zio.aws.s3.model.primitives.IsRestoreInProgress(value))
    override val restoreExpiryDate: Optional[RestoreExpiryDate] =
      zio.aws.core.internal
        .optionalFromNullable(impl.restoreExpiryDate())
        .map(value => zio.aws.s3.model.primitives.RestoreExpiryDate(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.RestoreStatus
  ): zio.aws.s3.model.RestoreStatus.ReadOnly = new Wrapper(impl)
}
