package zio.aws.s3.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class ServerSideEncryptionConfiguration(
    rules: Iterable[zio.aws.s3.model.ServerSideEncryptionRule]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.ServerSideEncryptionConfiguration = {
    import ServerSideEncryptionConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.ServerSideEncryptionConfiguration
      .builder()
      .rules(rules.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.ServerSideEncryptionConfiguration.ReadOnly =
    zio.aws.s3.model.ServerSideEncryptionConfiguration.wrap(buildAwsValue())
}
object ServerSideEncryptionConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.ServerSideEncryptionConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.ServerSideEncryptionConfiguration =
      zio.aws.s3.model.ServerSideEncryptionConfiguration(rules.map { item =>
        item.asEditable
      })
    def rules: List[zio.aws.s3.model.ServerSideEncryptionRule.ReadOnly]
    def getRules: ZIO[Any, Nothing, List[
      zio.aws.s3.model.ServerSideEncryptionRule.ReadOnly
    ]] = ZIO.succeed(rules)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.ServerSideEncryptionConfiguration
  ) extends zio.aws.s3.model.ServerSideEncryptionConfiguration.ReadOnly {
    override val rules
        : List[zio.aws.s3.model.ServerSideEncryptionRule.ReadOnly] = impl
      .rules()
      .asScala
      .map { item =>
        zio.aws.s3.model.ServerSideEncryptionRule.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.ServerSideEncryptionConfiguration
  ): zio.aws.s3.model.ServerSideEncryptionConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
